load("Dxxx_var.js");


//
// # Encoders
//

function EncoderStrip(extensionID)
{
	this.extensionID = extensionID;
	this.pages = [];
	this.colors = [];

	this.activeFXDev = -1;
	this.activeFXPage = -1;

	for (var t = 0; t < 8; t++)
	{
		this.colors[t] = [];
	}

	for (var t = 0; t < VPOT_PAGES_COUNT; t++)
	{
		this.pages[t] = new EncoderPage();
	}
}

EncoderStrip.prototype.sendValueToVpot = function(index, value, ledMode)
{
	getMidiPortByEx(this.extensionID).sendMidi(MIDIMSGTYPES.CC | ledMode, 0x30 | index, value);
}

EncoderStrip.prototype.RefreshValuesWithActivePage = function()
{
	if (this.activeFXPage != -1 && this.activeFXDev != -1) // FX
    {
        for (var i = 0; i < 8; i++)
			this.sendValueToVpot(i, FXEncoderPages[this.activeFXDev][this.activeFXPage].values[i], FXEncoderPages[this.activeFXDev][this.activeFXPage].ledMode[i]);

        return;
    }

	for ( var i = 0; i < 8; i++)
		this.sendValueToVpot(i, this.pages[activePage].values[i], this.pages[activePage].ledMode[i]);
}

EncoderStrip.prototype.setEncoder = function(page, index, value, ledMode)
{
	this.pages[page].newValue(index, value, ledMode);

	if (activePage == page)
	{
		this.sendValueToVpot(index, this.pages[page].values[index], this.pages[page].ledMode[index]);
	}
}

EncoderStrip.prototype.setColor = function(index, r, g, b)
{
	r = parseInt(r * 127);
	g = parseInt(g * 127);
	b = parseInt(b * 127);

	var changeFound = false;

	if (this.colors[index][0] != r)
	{
		this.colors[index][0] = r;
		getMidiPortByEx(this.extensionID).sendMidi(MIDIMSGTYPES.NOTEON | 1, VPOT_CLICK0 + index, r);
		changeFound = true;
	}

	if (this.colors[index][1] != g)
	{
		this.colors[index][1] = g;
		getMidiPortByEx(this.extensionID).sendMidi(MIDIMSGTYPES.NOTEON | 2, VPOT_CLICK0 + index, g);
		changeFound = true;
	}

	if (this.colors[index][2] != b || changeFound) // only refreshes after blue received
	{
		this.colors[index][2] = b;
		getMidiPortByEx(this.extensionID).sendMidi(MIDIMSGTYPES.NOTEON | 3, VPOT_CLICK0 + index, b);
	}
}

EncoderStrip.prototype.showPage = function(page)
{
	if (!((this.activeFXPage == -1 || this.activeFXDev == -1) && (page == VPOT_PAGE.EQ || page == VPOT_PAGE.FX))) // don't set indication for empty pages
	{
		for ( var i = 0; i < 8; i++)
		{
			getEncoderObjectPath(this.extensionID, i, page).setIndication(true);
		}
	}

	this.RefreshValuesWithActivePage();	
}

EncoderStrip.prototype.unshowPage = function(page)
{
	if (page == VPOT_PAGE.EQ && eqDevPosition == -1) // can't unshow that, fix it later
		return;
	
	for ( var i = 0; i < 8; i++)
	{
		getEncoderObjectPath(this.extensionID, i, page).setIndication(false);
	}
}


function EncoderPage()
{
	this.values = [];
	this.ledMode = [];

	for ( var i = 0; i < 8; i++)
	{
		this.values[i] = 0;
		this.ledMode[i] = 0;
	}
}

EncoderPage.prototype.newValue = function(index, value, ledMode)
{
	t = Math.round(value);
	this.values[index] = t;
	this.ledMode[index] = ledMode;
}


function setEncoder(encoderPage, trackNo, value)
{
	var ledMode = 1;

	if (encoderPage == VPOT_PAGE.DEVICE_PARAM || encoderPage == VPOT_PAGE.PAN || encoderPage == VPOT_PAGE.TRACK)
		ledMode = 2;
		
	this.Extensions[trackNoToExtensionID(trackNo)].encoderStrip.setEncoder(encoderPage, trackNoToTrackNo(trackNo), value, ledMode);
}

function setColor(trackNo, r, g, b)
{
	this.Extensions[trackNoToExtensionID(trackNo)].encoderStrip.setColor(trackNoToTrackNo(trackNo), r, g, b);
}

function clearEncoderPage(page)
{
	for (var exNo = 0; exNo < extensionCount; exNo++)
		for (var i = 0; i < 8; i++)
			this.Extensions[exNo].encoderStrip.pages[page].newValue(i, 0, 0);
}

function getEncoderObjectPath(exNo, index, page = -1)
{
	if (page == -1)
		page = activePage;

	if (page != VPOT_PAGE.EQ &&	page != VPOT_PAGE.FX)
		index = exNo * 8 + index;

	if (page == VPOT_PAGE.TRACK || page == VPOT_PAGE.PAN)
	{
		return trackBank.getTrack(index).getPan();
	}
	else if (page == VPOT_PAGE.FX)
	{
		return devicesFromSelectedTrackRemotePage[fxDevPosition][exNo + fxDevPageOffset].getParameter(index);
	}
	else if (page == VPOT_PAGE.EQ)
	{
		return devicesFromSelectedTrackRemotePage[eqDevPosition][exNo + eqDevPageOffset].getParameter(index);
	}
	else if (page == VPOT_PAGE.SEND0)
	{
		return trackBank.getTrack(index).getSend(0);
	}
	else if (page == VPOT_PAGE.SEND1)
	{
		return trackBank.getTrack(index).getSend(1);
	}
	else if (page == VPOT_PAGE.SEND2)
	{
		return trackBank.getTrack(index).getSend(2);
	}
	else if (page == VPOT_PAGE.SEND3)
	{
		return trackBank.getTrack(index).getSend(3);
	}
	else if (page == VPOT_PAGE.SEND4)
	{
		return trackBank.getTrack(index).getSend(4);
	}
}

function refreshFXEncoderPage(dev, page)
{
    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        if (Extensions[exNo].encoderStrip.activeFXPage == page && Extensions[exNo].encoderStrip.activeFXDev == dev)
            Extensions[exNo].encoderStrip.RefreshValuesWithActivePage();
    }
}