

//
// # Shared
//

function getMidiPortByTrack(trackNo)
{
    return host.getMidiOutPort(trackNoToPortNo(trackNo));
}

function getMidiPortByEx(exNo)
{
    return host.getMidiOutPort(exNo);
}

function trackNoToPortNo(trackNo)
{
    return (trackNo - (trackNo % 8)) / 8;
}

function trackNoToTrackNo(trackNo)
{
    return trackNo % 8;
}

function trackNoToExtensionID(trackNo)
{
    return parseInt(trackNo / 8);
}

function printText(txt)
{
    host.println(new Date().toLocaleTimeString() + " " + txt);
}