load("Dxxx_display.js");
load("Dxxx_encoders.js");
load("Dxxx_var.js");


//
// # Main File
//


var additionalExes = extensionCount - 1;

var isShiftPressed = false;
var isResetPressed = false;
var isScrubPressed = false;
var isPlay = false;

var faderTouchSelectsChannel = true;
var faderTouchSelectsChannelSetting;
var vuEnabled = true;
var vuEnabledSetting;
var hasDisplay = true;
var hasDisplaySetting;

var mcuActiveEncoderPage = VPOT_PAGE.TRACK;
var activeSendPage = VPOT_PAGE.SEND0;
var activeDevicePage = VPOT_PAGE.DEVICE_PARAM;
var parameterPageBuffer = -1;
var parameterPageBuffer = 0;
//var vuMeter = [0,8];
var vuMeterLastSend = [];
var selectedTrack = 0;
var numSendPages = 5;
var numDevicePages = 2;

var displayPages = [];
var encoderPages = [];

var automationWrite = false;
var automationWriteMode = "";

var preferences;

function init()
{
    printText("####################################################");
    printText("Initializing");

    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        for (var t = 0; t < 8; t++)
        {
            displayPages[exNo, t] = new DisplayPage(exNo);
            encoderPages[exNo, t] = new EncoderPage(exNo, t);
        }
    }
 
    //
    // # Host
    //

    host.getMidiInPort(0).setMidiCallback(onMidiMainDev); // Main dev

    if (extensionCount >= 2)
        host.getMidiInPort(1).setMidiCallback(onMidiExtension1);

    if (extensionCount >= 3)
        host.getMidiInPort(2).setMidiCallback(onMidiExtension2);

    if (extensionCount >= 4)
        host.getMidiInPort(3).setMidiCallback(onMidiExtension3);

    if (extensionCount >= 5)
        host.getMidiInPort(4).setMidiCallback(onMidiExtension4);

    if (extensionCount >= 6)
        host.getMidiInPort(5).setMidiCallback(onMidiExtension5);

    if (extensionCount >= 7)
        host.getMidiInPort(6).setMidiCallback(onMidiExtension6);

    if (extensionCount >= 8)
        host.getMidiInPort(7).setMidiCallback(onMidiExtension7);

    application = host.createApplication();

    cursorTrack = host.createCursorTrack(0, 1);
    cursorDevice = cursorTrack.createCursorDevice('cDev1', 'cDev1', 0, CursorDeviceFollowMode.FIRST_DEVICE); 
    cursorRemotePage = cursorDevice.createCursorRemoteControlsPage('cRCPage1', 8,'');

    selectedTrack = host.createCursorTrack(1, "selectedTrack", 2, 0, true);
    masterTrack = host.createMasterTrack(0);
    trackBank = host.createTrackBank(8 * extensionCount, 0, 99);

    transport = host.createTransport();


    //
    // # Settings
    //

    preferences = host.getPreferences();
    faderTouchSelectsChannelSetting = preferences.getBooleanSetting("Fader touch selects channel", "Faders", true);

    faderTouchSelectsChannelSetting.addValueObserver(function(value)
    {
        faderTouchSelectsChannel = value;
    });

    vuEnabledSetting = preferences.getBooleanSetting("VU metering enabled", "Display", true);

    vuEnabledSetting.addValueObserver(function(value)
    {
        vuEnabled = value;
    });

    hasDisplaySetting = preferences.getBooleanSetting("Display attached", "Display", true);

    hasDisplaySetting.addValueObserver(function(value)
    {
        hasDisplay = value;
    });


    //
    // # Selected Track
    //

    cursorTrack.position().addValueObserver(function getCursorTrackPositionObserver(value)
    {
        cursorTrackPositionObserver = value;
    }, 0);

    cursorTrack.pan().value().addValueObserver(128, function getCursorTrackPositionObserver(value)
    {
        sendChannelController(0, ENCODERS.PAN, value);
    });

    for (var t = 0; t < 4; t++)
    {
        cursorRemotePage.getParameter(t).value().addValueObserver(128, makeIndexedFunction(t, function getCursorTrackPositionObserver(index, value)
        {
            sendChannelController(0, index + ENCODERS.A1, value);
        }));
    }

    for ( var t = 0; t < 4; t++)
    {
        cursorRemotePage.getParameter(t + 4).value().addValueObserver(128, makeIndexedFunction(t, function getCursorTrackPositionObserver(index, value)
        {
            sendChannelController(0, index + ENCODERS.A5, value);
        }));
    }

    refreshRemoteControlsPages(true);


    //
    // # Transport
    //

    transport.addIsPlayingObserver(function(on)
    {
        isPlay = on;
        sendNoteOn(0, TRANSPORT.PLAY, on ? 127 : 0);
        sendNoteOn(0, TRANSPORT.STOP, on ? 0 : 127);
    });

    transport.addIsLoopActiveObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.CYCLE, on ? 127 : 0);
    });

    transport.addIsRecordingObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.RECORD, on ? 127 : 0);
    });

    transport.addIsWritingArrangerAutomationObserver(function(on)
    {
        automationWrite = on;
    });

    transport.addIsWritingClipLauncherAutomationObserver(function(on)
    {
        sendNoteOn(0, AUTOMATION.TRIM, on ? 127 : 0);
    });

    transport.addAutomationWriteModeObserver(function(mode)
    {
        setAutomationModeLED(mode);
    });

    transport.addAutomationOverrideObserver(function(on)
    {
        sendNoteOn(0, AUTOMATION.GROUP, on ? 127 : 0);
    });

    transport.addClickObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.CLICK, on ? 127 : 0);
    });

    transport.addOverdubObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.REPLACE, on ? 127 : 0);
    });

    transport.getPosition().addTimeObserver("", 3, 2, 2, 3, function(value)
    {
        setTransportPositionDisplay(value);
    });


    //
    // # Track Bank, Extensions, DxxxF
    //

    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        for (var t = 0; t < 8; t++)
        {
            var trackNo = t + exNo * 8;
            var track = trackBank.getTrack(trackNo);
            
            track.addNameObserver(8, "", makeIndexedFunction(trackNo, function(index, value)
            {
                if (hasDisplay) // Display text
                    writeToColumn(trackNoToPortNo(index), DISPLAY_PAGES.NAME_AND_VOLUME, 0, trackNoToTrackNo(index), value);
            }));

            track.volume().addValueDisplayObserver(8, "", makeIndexedFunction(trackNo, function(index, value)
            {
                if (hasDisplay) // Display text
                    writeToColumn(trackNoToPortNo(index), DISPLAY_PAGES.NAME_AND_VOLUME, 1, trackNoToTrackNo(index), value);
            }));
        
            host.getMidiOutPort(exNo).sendMidi(MIDIMSGTYPES.CHANNELPRESSURE,  0xf + (t << 4), 0); // reset peak hold

            vuMeterLastSend[trackNo] = new Date().valueOf() - 5000;
            track.addVuMeterObserver(14, -1, true, makeIndexedFunction(trackNo, function(index, vuMeter)
            {
                if (vuEnabled && hasDisplay && isPlay) // Display VU meters
                {
                    var milliseconds = new Date().valueOf();

                    if (vuMeterLastSend[index] < milliseconds - 250) // limit updates to 4 FPS
                    {
                        host.getMidiOutPort(trackNoToPortNo(index)).sendMidi(MIDIMSGTYPES.CHANNELPRESSURE, parseInt(vuMeter) + (trackNoToTrackNo(index) << 4), 0);
                        vuMeterLastSend[index] = milliseconds; // millisecs
                    }  
                }
            }));

            track.volume().addValueObserver(16384, makeIndexedFunction(trackNo, function(index, value) // Fader positions
            {
                //encoderPages[trackNoToPortNo(index), VPOT_PAGE.VOLUME].setEncoder(index, value, 0, 0);
                host.getMidiOutPort(trackNoToPortNo(index)).sendMidi(MIDIMSGTYPES.PITCHBEND | trackNoToTrackNo(index), value & 127, value >> 7 & 127);
            }));

            track.addIsSelectedObserver(makeIndexedFunction(trackNo, function(index, isSelected)
            {
                if (isSelected)
                {
                    host.getMidiOutPort(trackNoToPortNo(index)).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.SELECT0 + trackNoToTrackNo(index), 127);
                    this.selectedTrack = index;
                }
                else host.getMidiOutPort(trackNoToPortNo(index)).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.SELECT0 + trackNoToTrackNo(index), 0);
            }));

            track.getMute().addValueObserver(makeIndexedFunction(trackNo, function(index, on)
            {
                host.getMidiOutPort(trackNoToPortNo(index)).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.MUTE0 + trackNoToTrackNo(index), on ? 127 : 0);
            }));

            track.getSolo().addValueObserver(makeIndexedFunction(trackNo, function(index, on)
            {
                host.getMidiOutPort(trackNoToPortNo(index)).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.SOLO0 + trackNoToTrackNo(index), on ? 127 : 0);
            }));

            track.getArm().addValueObserver(makeIndexedFunction(trackNo, function(index, on)
            {
                host.getMidiOutPort(trackNoToPortNo(index)).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.ARM0 + trackNoToTrackNo(index), on ? 127 : 0);
            }));

            track.getVolume().setLabel("V" + (trackNo + 1));
            track.getVolume().setIndication(true);
        }
    }


    //
    // # Master Track
    //

    masterTrack.getVolume().addValueObserver(16384, function(value)
    {
        sendPitchBend(8, value);
    });
    masterTrack.getVolume().setIndication(true);


    //host.requestFlush();

    printText("Initialized");
}

function trackNoToPortNo(trackNo)
{
    return (trackNo - (trackNo % 8)) / 8;
}

function trackNoToTrackNo(trackNo)
{
    return trackNo % 8;
}

function printText(txt)
{
    host.println(new Date().toLocaleTimeString() + " " + txt);
}

function exit()
{
    sendSysex(SYSEX_HDR + "61 f7"); // All faders to the bottom
    sendSysex(SYSEX_HDR + "62 f7"); // All leds off

    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        clearLCD(exNo);
    }
}

function changeRemoteControlsPage(toNextNotPrev)
{
    refreshRemoteControlsPages(false);

    if (toNextNotPrev)
        cursorRemotePage.selectNextPage(true);
    else
        cursorRemotePage.selectPreviousPage(true);

    refreshRemoteControlsPages(true);
}

function refreshRemoteControlsPages(indicate)
{
    for ( var t = 0; t < 8; t++)
    {
        cursorRemotePage.getParameter(t).setIndication(indicate);
    }
}

function flush()
{

}

function onMidiMainDev(status, data1, data2)
{
    onMidi(0, status, data1, data2);
}

function onMidiExtension1(status, data1, data2)
{
    onMidi(1, status, data1, data2);
}

function onMidiExtension2(status, data1, data2)
{
    onMidi(2, status, data1, data2);
}

function onMidiExtension3(status, data1, data2)
{
    onMidi(3, status, data1, data2);
}

function onMidiExtension4(status, data1, data2)
{
    onMidi(4, status, data1, data2);
}

function onMidiExtension5(status, data1, data2)
{
    onMidi(5, status, data1, data2);
}

function onMidiExtension6(status, data1, data2)
{
    onMidi(6, status, data1, data2);
}

function onMidiExtension7(status, data1, data2)
{
    onMidi(7, status, data1, data2);
}

function onMidi(channel, status, data1, data2)
{
    //printMidi(status, data1, data2);

    if (isPitchBend(status)) ////////only the motor faders send/receive pitch bend messages(14bit --> 0 - 16383)
    {
        var index = MIDIChannel(status) + channel * 8;

        if (index == 8 && channel == 0) 
        {
            masterTrack.getVolume().set(pitchBendValue(data1, data2), 16384); // 16384 - 127);
        }
        else if (MIDIChannel(status) < 8)
        {
            trackBank.getTrack(index).getVolume().set(pitchBendValue(data1, data2), 16384); // 16384 - 127); why the f -127???????? without it works perfectly
        }       
    }

    if (isNoteOff(status) && data2)
    {
        switch (data1)
        {
            case ENCODERCLICKS.PAN:
                cursorTrack.pan().reset();
                break;
            case ENCODERCLICKS.A1:
            case ENCODERCLICKS.A2:
            case ENCODERCLICKS.A3:
            case ENCODERCLICKS.A4:
            case ENCODERCLICKS.A5:
            case ENCODERCLICKS.A6:
            case ENCODERCLICKS.A7:
            case ENCODERCLICKS.A8:
                cursorRemotePage.getParameter(data1 - ENCODERCLICKS.A1).reset();
                break;
            case ENCODERCLICKS.VOLUME:
                cursorTrack.mute().toggle();
                break;
        };
    }

    //all buttons, the click of the encoders and the touch of the motor faders send/receive note on messages (release a button = velocity 0)
    if (isNoteOn(status)) 
    {
        if (data1 == MODIFIER.SHIFT)
        {
            isShiftPressed = data2 > 0;
        }
        else if (data1 == MODIFIER.OPTION)
        {
            isResetPressed = data2 > 0;
        }
        else if (data1 == SCRUB) 
        {
            isScrubPressed = data2 > 0;
        }
        else if (data1 >= VPOT_CLICK0 && data1 < (VPOT_CLICK0 + 8)) //
        {
            if (isResetPressed)
            {
                getEncoderObjectPath(data1 - VPOT_CLICK0).reset(); // if reset is pressed, reset the parameter of the clicked encoder to its default value
            }  
        }

        if (data2 > 0) // Check button presses (but not releases) in here
        {
            if (data1 >= VPOT_ASSIGN.TRACK && data1 <= VPOT_ASSIGN.INSTRUMENT) //  the 4 mode buttons change the vpot assignement and what's displayed 
            {
                switch (data1)
                {
                    case VPOT_ASSIGN.TRACK:
                        if (mcuActiveEncoderPage != VPOT_PAGE.TRACK)
                        {
                            setEncoderPage(VPOT_PAGE.TRACK);
                            setDisplayPage(DISPLAY_PAGES.NAME_AND_VOLUME);
                            sendNoteOn(0, VPOT_ASSIGN.TRACK, 127);
                            sendNoteOn(0, VPOT_ASSIGN.SEND, 0);
                            sendNoteOn(0, VPOT_ASSIGN.PAN, 0);
                            sendNoteOn(0, VPOT_ASSIGN.DEVICE, 0);
                            setIndications("pan");
                        }
                        break;
                    case VPOT_ASSIGN.SEND:
                        if (mcuActiveEncoderPage == activeSendPage) // if already in send mode, switch the send page
                        {
                            switchActiveSendPage();
                            setEncoderPage(activeSendPage);
                            setDisplayPage(activeSendPage);
                            setIndications("send");
                        }
                        else if (mcuActiveEncoderPage != VPOT_PAGE.SEND0 && mcuActiveEncoderPage != VPOT_PAGE.SEND1 && mcuActiveEncoderPage != VPOT_PAGE.SEND2 && mcuActiveEncoderPage != VPOT_PAGE.SEND3 && mcuActiveEncoderPage != VPOT_PAGE.SEND4)
                        {
                            setEncoderPage(activeSendPage);
                            setDisplayPage(activeSendPage);
                            sendNoteOn(0, VPOT_ASSIGN.TRACK, 0);
                            sendNoteOn(0, VPOT_ASSIGN.SEND, 127);
                            sendNoteOn(0, VPOT_ASSIGN.PAN, 0);
                            sendNoteOn(0, VPOT_ASSIGN.DEVICE, 0);
                            setIndications("send");
                        }
                        break;
                    case VPOT_ASSIGN.PAN:
                        if (mcuActiveEncoderPage != VPOT_PAGE.PAN)
                        {
                            setEncoderPage(VPOT_PAGE.PAN);
                            setDisplayPage(DISPLAY_PAGES.NAME_AND_PAN);
                            sendNoteOn(0, VPOT_ASSIGN.TRACK, 0);
                            sendNoteOn(0, VPOT_ASSIGN.SEND, 0);
                            sendNoteOn(0, VPOT_ASSIGN.PAN, 127);
                            sendNoteOn(0, VPOT_ASSIGN.DEVICE, 0);
                            setIndications("pan");
                        }
                        break;
                    case VPOT_ASSIGN.DEVICE:
                        if (mcuActiveEncoderPage == activeDevicePage) // if already in device mode, toggle between displaying mapped parameters or device presets
                        {
                            switchActiveDevicePage();
                            setEncoderPage(activeDevicePage);
                            setDisplayPage(activeDevicePage);
                            setIndications("device");
                        }
                        else if (mcuActiveEncoderPage != VPOT_PAGE.DEVICE_PARAM && mcuActiveEncoderPage != VPOT_PAGE.DEVICE_PRESETS)
                        {
                            setEncoderPage(activeDevicePage);
                            setDisplayPage(activeDevicePage);
                            sendNoteOn(0, VPOT_ASSIGN.TRACK, 0);
                            sendNoteOn(0, VPOT_ASSIGN.PAN, 0);
                            sendNoteOn(0, VPOT_ASSIGN.SEND, 0);
                            sendNoteOn(0, VPOT_ASSIGN.DEVICE, 127);
                            setIndications("device");
                        }
                        break;
                }
            }

            // ///////////////////////////////////// channel buttons ///////

            else if (data1 >= 0 && data1 <= 7) // is one of the arm buttons pressed
            {
                var index = data1 - CHANNEL_BUTTON.ARM0 + channel * 8; //which arm button is pressed
                trackBank.getTrack(index).getArm().toggle(); // tell the application to toggle the state of the corresponding arm button
            }

            else if (data1 >= 8 && data1 <= 15) // is one of the solo buttons pressed
            {
                var index = data1 - CHANNEL_BUTTON.SOLO0 + channel * 8; //which solo button is pressed
                trackBank.getTrack(index).getSolo().toggle(); // tell the application to toggle the state of the corresponding solo button
            }
            else if (data1 >= 16 && data1 <= 23) // is one of the mute buttons pressed
            {

                var index = data1 - CHANNEL_BUTTON.MUTE0 + channel * 8; //which mute button is pressed
                trackBank.getTrack(index).getMute().toggle(); // tell the application to toggle the state of the corresponding mute button
            }
            else if (data1 >= 24 && data1 <= 31) // is a select button pressed
            {
                var index = data1 - CHANNEL_BUTTON.SELECT0 + channel * 8; //which select button is pressed
                trackBank.getTrack(index).select(); // tell the application to toggle the state of the corresponding arm button
            }
            else if (data1 >= 104 && data1 <= 111) // fader touch select
            {
                if (faderTouchSelectsChannel)
                {
                    var index = data1 - CHANNEL_BUTTON.TOUCH0 + channel * 8; //which select button is pressed
                    trackBank.getTrack(index).select(); // tell the application to toggle the state of the corresponding arm button
                }
            }

            // /////////////////////////////// transport ///////

            switch (data1)
            {
                case TRANSPORT.PLAY:
                    transport.play();
                    break;
                case TRANSPORT.STOP:
                    transport.stop();
                    break;
                case TRANSPORT.RECORD:
                    transport.record();
                    break;
                case TRANSPORT.REW:
                    transport.rewind();
                    break;
                case TRANSPORT.FF:
                    transport.fastForward();
                    break;
                case TRANSPORT.CYCLE:
                    transport.toggleLoop();
                    break;
                case TRANSPORT.CLICK:
                    transport.toggleClick();
                    break;
                case AUTOMATION.TRIM:
                    transport.toggleWriteClipLauncherAutomation();
                    break;
                case AUTOMATION.GROUP:
                    transport.resetAutomationOverrides();
                    break;
                case AUTOMATION.READ_OFF:
                    transport.toggleWriteArrangerAutomation();
                    break;
                case AUTOMATION.LATCH:
                    transport.setAutomationWriteMode("latch");
               if (!automationWrite) transport.toggleWriteArrangerAutomation();
                    break;
                case AUTOMATION.TOUCH:
                    transport.setAutomationWriteMode("touch");
               if (!automationWrite) transport.toggleWriteArrangerAutomation();
                    break;
                case AUTOMATION.WRITE:
                    transport.setAutomationWriteMode("write");
               if (!automationWrite) transport.toggleWriteArrangerAutomation();
                    break;
                case TRANSPORT.REPLACE:
                    transport.toggleOverdub();
                    break;
                case FADER_BANKS.FLIP:

                break;
                case FADER_BANKS.BANK_UP:
                    trackBank.scrollChannelsPageUp();
                    // setIndications("pan");
                    break;
                case FADER_BANKS.BANK_DOWN:
                    trackBank.scrollChannelsPageDown();
                    // setIndications("pan");
                    break;
                case FADER_BANKS.CHANNEL_UP:
                    changeRemoteControlsPage(false);
                    break;
                case FADER_BANKS.CHANNEL_DOWN:
                    changeRemoteControlsPage(true);
                    break;
                case APPLICATION.CANCEL:
                    application.escape();
                    break;
                case APPLICATION.ENTER:
                    application.enter();
                    break;
                case APPLICATION.TOGGLE_NOTE_EDITOR:
                    application.toggleNoteEditor();
                    break;
                case APPLICATION.TOGGLE_DEVICES:
                    application.toggleDevices();
                    break;
                case APPLICATION.TOGGLE_AUTOMATION_EDITOR:
                    application.toggleAutomationEditor();
                    break;
                case APPLICATION.TOGGLE_MIXER:
                    application.toggleMixer();
                    break;
                case APPLICATION.TOGGLE_BROWSER:
                    application.toggleBrowserVisibility();
                    break;
                case TOGGLE_VU_METER:
                    break;

            }
        }
        else if (data2 == 0) // Check button release, no press
        {
            switch (data1)
            {
                case APPLICATION.UNDO_REDO:
                    sendNoteOn(0, APPLICATION.UNDO_REDO, 0);
                    break;
            }
        }
    }

    // ////////////////////////////////////// isChannelController //////

    if (isChannelController(status)) //encoders(vpots) and the wheel send/receive channel controller messages
    {
        var index = 0;
        data1 != TRANSPORT.WHEEL ? index = data1 - VPOT0 : index = data1; // distinguish vpots from wheel
        var delta = data2;
        if (delta > 64) // if an encoder is turned counterclockwise..
        {
            delta = (-1) * (Math.round(delta) - 64); // ..do this math
        }

        /* vpots */
        // if (data1 >= VPOT0 && data1 < (VPOT0 + 8)) // if the cc comes from a vpot..
        // {
        //     getEncoderObjectPath(index).inc(delta, 200); // ..get the target parameter dependent on the active encoder page and if flip is on or off
        // }
        // else 
        if (data1 == TRANSPORT.WHEEL)
        {
            delta = delta *2; // increase speed
            transport.incPosition(delta, true);
        }
        else if (data1 == ENCODERS.PAN)
        {
            printText(delta);
            cursorTrack.pan().value().inc(delta, 128);
        }
        else if ((data1 == ENCODERS.A1) || (data1 == ENCODERS.A2) || (data1 == ENCODERS.A3) || (data1 == ENCODERS.A4)) // Bind assignable encoders to colored encoder pages
        {
            cursorRemotePage.getParameter(data1 - ENCODERS.A1).inc(delta, 128);
        }
        else if ((data1 == ENCODERS.A5) || (data1 == ENCODERS.A6) || (data1 == ENCODERS.A7) || (data1 == ENCODERS.A8))
        {
            cursorRemotePage.getParameter(data1 - ENCODERS.A5 + 4).inc(delta, 128);
        }
    }
}

function onSysex(data)
{

}

function makeIndexedFunction(index, f) // this is needed to 
{
    return function(value)
    {
        f(index, value);
    };
}

function setAutomationModeLED(mode) 
{
   automationWriteMode = mode;
}

function switchActiveSendPage() // when the active encoder page is 'send' and the send mode button is pressed 
{
    if (activeSendPage < numSendPages + 3)
        activeSendPage += 1;
    else activeSendPage = VPOT_PAGE.SEND0;
}

function switchActiveDevicePage()
{
    if (activeDevicePage < numDevicePages + 1)
        activeDevicePage += 1;
    else activeDevicePage = VPOT_PAGE.DEVICE_PARAM;
}

function setIndications(page) // sets the color indication in the application depending on what the encoders currently control
{
    // switch (page)
    // {
    //     case "pan":
    //         for ( var i = 0; i < 8; i++)
    //         {
    //             var track = trackBank.getTrack(i);
    //             var parameter = cursorDevice.getParameter(i);
    //             // track.getVolume().setIndication(true);
    //             track.getPan().setIndication(true);
    //             track.getSend(activeSendPage - 4).setIndication(false);
    //             parameter.setIndication(false);
    //         }
    //         break;
    //     case "send":
    //         for ( var i = 0; i < 8; i++)
    //         {
    //             var track = trackBank.getTrack(i);
    //             var parameter = cursorDevice.getParameter(i);

    //             // track.getVolume().setIndication(true);
    //             track.getPan().setIndication(false);
    //             parameter.setIndication(false);

    //             for ( var s = 0; s < numSendPages; s++)
    //             {
    //                 track.getSend(s).setIndication(false);
    //             }
    //             track.getSend(activeSendPage - 4).setIndication(true);
    //         }
    //         break;
    //     case "device":
    //         for ( var i = 0; i < 8; i++)
    //         {
    //             var track = trackBank.getTrack(i);
    //             var parameter = cursorDevice.getParameter(i);

    //             parameter.setIndication(true);
    //             track.getPan().setIndication(false);
    //             track.getSend(activeSendPage - 4).setIndication(false);
    //         }
    //         break;
    // }
}



