include_file("resource://com.presonus.musicdevices/sdk/controlsurfacecomponent.js");
include_file("resource://com.presonus.musicdevices/presonus/pslsurfacecomponent.js");
include_file("AspProtocol.js");
var ChannelAssignmentMode;
(function (ChannelAssignmentMode) {
    ChannelAssignmentMode[ChannelAssignmentMode["kTrackMode"] = 0] = "kTrackMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kPlugMode"] = 1] = "kPlugMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kSendMode"] = 2] = "kSendMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kPanMode"] = 3] = "kPanMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kTimeMode"] = 4] = "kTimeMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kCueMode"] = 5] = "kCueMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kInputGainMode"] = 6] = "kInputGainMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kMacroMode"] = 7] = "kMacroMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kEQMode"] = 8] = "kEQMode";
    ChannelAssignmentMode[ChannelAssignmentMode["kAssignModeMax"] = 8] = "kAssignModeMax";
    ChannelAssignmentMode[ChannelAssignmentMode["kInvalidMode"] = -1] = "kInvalidMode";
})(ChannelAssignmentMode || (ChannelAssignmentMode = {}));
var PanEncoderMode;
(function (PanEncoderMode) {
    PanEncoderMode[PanEncoderMode["kChannelPanEncoderMode"] = 0] = "kChannelPanEncoderMode";
    PanEncoderMode[PanEncoderMode["kChannelAudioClickMode"] = 1] = "kChannelAudioClickMode";
    PanEncoderMode[PanEncoderMode["kLinkEncoderMode"] = 2] = "kLinkEncoderMode";
    PanEncoderMode[PanEncoderMode["kPlugEncoderMode"] = 3] = "kPlugEncoderMode";
})(PanEncoderMode || (PanEncoderMode = {}));
var BigEncoderMode;
(function (BigEncoderMode) {
    BigEncoderMode[BigEncoderMode["kNavigationMode"] = 0] = "kNavigationMode";
    BigEncoderMode[BigEncoderMode["kChannelMode"] = 1] = "kChannelMode";
    BigEncoderMode[BigEncoderMode["kZoomMode"] = 2] = "kZoomMode";
    BigEncoderMode[BigEncoderMode["kScrollMode"] = 3] = "kScrollMode";
    BigEncoderMode[BigEncoderMode["kBankMode"] = 4] = "kBankMode";
    BigEncoderMode[BigEncoderMode["kMasterMode"] = 5] = "kMasterMode";
    BigEncoderMode[BigEncoderMode["kSectionMode"] = 7] = "kSectionMode";
    BigEncoderMode[BigEncoderMode["kMarkerMode"] = 8] = "kMarkerMode";
    BigEncoderMode[BigEncoderMode["kPageSelectMode"] = 9] = "kPageSelectMode";
    BigEncoderMode[BigEncoderMode["kPanSelectMode"] = 10] = "kPanSelectMode";
    BigEncoderMode[BigEncoderMode["kBigEncoderModeMax"] = 10] = "kBigEncoderModeMax";
    BigEncoderMode[BigEncoderMode["kInvalidBigEncoderMode"] = -1] = "kInvalidBigEncoderMode";
})(BigEncoderMode || (BigEncoderMode = {}));
var FolderSlotIndex;
(function (FolderSlotIndex) {
    FolderSlotIndex[FolderSlotIndex["kSlotAll"] = 0] = "kSlotAll";
    FolderSlotIndex[FolderSlotIndex["kSlotFirst"] = 1] = "kSlotFirst";
})(FolderSlotIndex || (FolderSlotIndex = {}));
var ScrollDirection;
(function (ScrollDirection) {
    ScrollDirection[ScrollDirection["kLeft"] = -1] = "kLeft";
    ScrollDirection[ScrollDirection["kRight"] = 1] = "kRight";
})(ScrollDirection || (ScrollDirection = {}));
const kMacroBankKnobCount = 8;
const kUndefinedChannelType = "";
const kFaderTapTimeoutMs = 450;
class Assignment {
    constructor() {
        this.mode = ChannelAssignmentMode.kTrackMode;
        this.controlLinkFocus = false;
        this.encoderMode = PanEncoderMode.kChannelPanEncoderMode;
        this.bigEncoderMode = BigEncoderMode.kBankMode;
        this.previousBigEncoderMode = BigEncoderMode.kInvalidBigEncoderMode;
        this.sendIndex = FolderSlotIndex.kSlotAll;
        this.cueIndex = FolderSlotIndex.kSlotAll;
        this.selectedBank = 0;
        // this.armMode = false;
        this.panFocus = false;
    }
    isPlugOverview() {
        return this.mode == ChannelAssignmentMode.kPlugMode && !this.controlLinkFocus;
    }
    isPlugEditModeWithFocus() {
        return this.mode == ChannelAssignmentMode.kPlugMode && this.controlLinkFocus;
    }
    isPanFocusMode() {
        return this.mode == ChannelAssignmentMode.kPanMode && this.panFocus;
    }
    isSendVisible(sendIndex) {
        return this.mode == ChannelAssignmentMode.kSendMode && this.sendIndex == sendIndex;
    }
    isCueVisible(cueIndex) {
        return this.mode == ChannelAssignmentMode.kCueMode && this.cueIndex == cueIndex;
    }
    isBigEncoderOverlayMode() {
        return this.mode == ChannelAssignmentMode.kPlugMode || this.isPanFocusMode();
    }
    sync(other) {
        this.mode = other.mode;
        this.selectedBank = other.selectedBank;
        this.sendIndex = other.sendIndex;
        this.cueIndex = other.cueIndex;
        this.panFocus = other.panFocus;
    }
}
const kLinkColorOff = "white";
const kLinkColorOn = "blue";
const kLinkColorLocked = "red";
const kRecordArmColor = "red";
const kPlugEditColor = "yellow";
const kPlugSelectColor = "white";
const kNormalBankColor = "blue";
const kShiftBankColor = "darkorange";
const kMacroColor = "green";
const kAutoLatchColor = "red";
const kAutoTrimColor = "red";
const kAutoOffColor = "white";
const kAutoTouchColor = "orange";
const kAutoWriteColor = "red";
const kAutoReadColor = "green";
const kBypassColor = "blue";
const kAspComponentMixerBanks = [
    PreSonus.MixerConsoleBankID.kAudioTrack,
    PreSonus.MixerConsoleBankID.kAudioSynth,
    PreSonus.MixerConsoleBankID.kAudioBus,
    PreSonus.MixerConsoleBankID.kAudioVCA,
    PreSonus.MixerConsoleBankID.kRemoteAll,
    PreSonus.MixerConsoleBankID.kAudioInput,
    PreSonus.MixerConsoleBankID.kAudioAux,
    PreSonus.MixerConsoleBankID.kAudioOutput,
    PreSonus.MixerConsoleBankID.kAudioFX,
    PreSonus.MixerConsoleBankID.kUser
];
const kBankButtonCount = 5;

class ChannelStrip 
{
    constructor() {
    }
    setFaderValue(element, paramName) {
        element.connectAliasParam(this.faderValue, paramName);
    }
    setEncoderValue(element, paramName) {
        element.connectAliasParam(this.encoderValue, paramName);
    }
    clearFaderValue() {
        this.faderValue.setOriginal(null);
    }
    setDisplayValue(element, paramName) {
        element.connectAliasParam(this.displayValue, paramName);
    }
    clearDisplayValue() {
        this.displayValue.setOriginal(null);
    }
    setDisplayLineDirect(line, param) {
        this.lines[line].setOriginal(param);
    }
    setDisplayLine(line, element, paramName) {
        element.connectAliasParam(this.lines[line], paramName);
    }
    clearDisplayLine(line) {
        this.lines[line].setOriginal(null);
    }
    setSelectValue(element, paramName) {
        element.connectAliasParam(this.selectValue, paramName);
    }
    clearSelectValue() {
        this.selectValue.setOriginal(null);
    }
    setTrackColor(element, paramName) {
        element.connectAliasParam(this.trackColor, paramName);
    }
    clearSelectColor() {
        this.trackColor.setOriginal(null);
    }
    restoreFaderDefaultValue() {
        if (this.faderValue.hasOriginal())
            this.faderValue.setValue(this.faderValue.default, true);
    }
    updateFaderLastTouched() {
        this.lastTouched = new Date();
    }
    clear() {
        this.clearDisplayValue();
        for (let lineIndex = 0; lineIndex < this.lines.length; lineIndex++)
            this.clearDisplayLine(lineIndex);
        this.clearSelectColor();
        this.clearSelectValue();
        this.clearFaderValue();
    }
}
ChannelStrip.kInvalidChannelIndex = -1;
class AspComponent extends FocusChannelPanComponent {
    constructor(faderCount) {
        super();
        this.faderCount = faderCount;
        this.pagingStatusIndex = faderCount - 1;
        this.channels = [];
    }
    onInit(hostComponent) {
        super.onInit(hostComponent);
        this.debugLog = true; // ###########################
        this.assignment = new Assignment;
        this.channelBankElement = this.mixerMapping.find("ChannelBankElement");
        let macroBankElement = this.focusChannelElement.find("MacroBankElement");
        this.focusSendsBankElement = this.focusChannelElement.find("SendsBankElement");
        this.focusCuesBankElement = this.focusChannelElement.find("CuesBankElement");
        this.focusInsertsBankElement = this.focusChannelElement.find("InsertsBankElement");
        this.plugBankElement = this.root.getGenericMapping().getElement(0);
        let paramList = hostComponent.paramList;
        this.assignModeParam = paramList.addInteger(0, ChannelAssignmentMode.kAssignModeMax, "assignMode");
        this.bigEncoderModeParam = paramList.addInteger(0, BigEncoderMode.kBigEncoderModeMax, "bigEncoderMode");
        this.bigEncoderModeParam.value = BigEncoderMode.kBankMode;
        this.linkModeParam = paramList.addParam("linkMode");
        this.lockEncoderParam = paramList.addParam("lockEncoder");
        let pagingComponent = hostComponent.find(PreSonus.ComponentID.kPaging);
        this.pagingStatusParam = pagingComponent.findParameter(PreSonus.ParamID.kPagingStatus);
        this.bankList = paramList.addList("bankList");
        for (let i in kAspComponentMixerBanks)
            this.bankList.appendString(kAspComponentMixerBanks[i]);
        this.bankList.value = kAspComponentMixerBanks.indexOf(PreSonus.MixerConsoleBankID.kRemoteAll);
        this.assignment.selectedBank = this.bankList.value;
        this.bankIndicator = paramList.addInteger(0, kBankButtonCount - 1, "bankIndicator");
        this.bankIndicator.value = this.bankList.value;
        this.bankColor = paramList.addColor("bankColor");
        this.bankColor.fromString(kNormalBankColor);   
        this.assignmentString = paramList.addAlias("assignmentString");       
        this.recentParamElement = this.root.getRecentParamMapping();
        for (let i = 0; i < this.faderCount; i++) 
        {
            let channel = new ChannelStrip;
            channel.lineStyles = [];
            for (let line = 0; line < Asp.Support.kMaxLineCount; line++)
                channel.lineStyles.push(Asp.TextStyle.kCenter);
            channel.channelElement = this.channelBankElement.getElement(i);
            if (i < kMacroBankKnobCount) 
            {
                channel.macroFloatElement = macroBankElement.getElement(i);
                channel.macroBoolElement = macroBankElement.getElement(i + kMacroBankKnobCount);
            }
            channel.plugFaderElement = this.plugBankElement.find("fader[" + i + "]");
            channel.plugEncoderElement = this.plugBankElement.find("Encoder[" + i + "]");
            channel.plugButtonElement = this.plugBankElement.find("PushEncoder[" + i + "]");
            channel.insertSlotElement = this.focusInsertsBankElement.getElement(i);
            channel.sendsBankElement = channel.channelElement.find("SendsBankElement");
            channel.cuesBankElement = channel.channelElement.find("CuesBankElement");
            channel.displayMode = paramList.addInteger(0, Asp.DisplayMode.kNumModes - 1, "displayMode" + i);
            channel.lines = [];
            for (let line = 0; line < Asp.Support.kMaxLineCount; line++)
                channel.lines.push(paramList.addAlias("display" + i + "Line" + line));
            channel.displayValue = paramList.addAlias("displayValue" + i);
            channel.selectValue = paramList.addAlias("selectValue" + i);
            channel.lastSelectMode = ChannelAssignmentMode.kInvalidMode;
            channel.trackColor = paramList.addAlias("trackColor" + i);
            channel.faderValue = paramList.addAlias("faderValue" + i);
            channel.encoderValue = paramList.addAlias("encoderValue" + i);
            channel.pushEncoderValue = paramList.addAlias("pushEncoderValue" + i);
            channel.armValue = paramList.addAlias("armValue" + i);
            channel.channelType = kUndefinedChannelType;
            channel.lastTouched = new Date();
            channel.currentEncoderParam = PreSonus.ParamID.kPan;
            channel.currentEncoderElement = channel.channelElement;
            this.channels.push(channel);
        }
        this.faderTouchTitle = paramList.addString("faderTouchTitle");
        this.timeCodeMode = paramList.addParam("timeCodeMode");
        this.linkColor = paramList.addColor("linkColor");
        this.linkColor.fromString(kLinkColorOff);
        this.shiftModifer = paramList.addParam("shiftModifier");
        this.shiftPressedModifier = paramList.addParam("shiftHoldModifier");
        this.bypassAlias = paramList.addAlias("bypassAlias");
        this.autoModeAlias = paramList.addAlias("autoModeAlias");
        this.recordArmColor = paramList.addColor("recordArmColor");
        this.recordArmColor.fromString(kRecordArmColor);
        this.plugEditColor = paramList.addColor("plugEditColor");
        this.plugEditColor.fromString(kPlugEditColor);
        this.plugSelectColor = paramList.addColor("plugSelectColor");
        this.plugSelectColor.fromString(kPlugSelectColor);
        paramList.addColor("macroColor").fromString(kMacroColor);
        paramList.addColor("shiftColor").fromString(kShiftBankColor);
        paramList.addColor("autoLatchColor").fromString(kAutoLatchColor);
        paramList.addColor("autoTrimColor").fromString(kAutoTrimColor);
        paramList.addColor("autoOffColor").fromString(kAutoOffColor);
        paramList.addColor("autoTouchColor").fromString(kAutoTouchColor);
        paramList.addColor("autoWriteColor").fromString(kAutoWriteColor);
        paramList.addColor("autoReadColor").fromString(kAutoReadColor);
        paramList.addColor("bypassColor").fromString(kBypassColor);
        this.slotInfo = paramList.addString("slotInfo");
    }
    getDeviceSyncID() {
        return "D700";
    }
    getSyncData() {
        return this.assignment;
    }
    onSyncDevice(otherData) {
        this.assignment.sync(otherData);
        let updatedMode = this.assignment.mode;
        if (updatedMode != this.assignModeParam.value) {
            this.assignModeParam.setValue(updatedMode, false);
        }
        let updatedBank = this.assignment.selectedBank;
        if (updatedBank != this.bankList.value) {
            this.bankList.setValue(updatedBank, false);
            this.updateBank(updatedBank);
        }
        this.updateAssignment();
    }
    updateBank(selectedBank) {
        let bankName = this.bankList.string;
        this.channelBankElement.selectBank(bankName);
        if (selectedBank >= kBankButtonCount) {
            this.bankIndicator.value = selectedBank - kBankButtonCount;
            this.bankColor.fromString(kShiftBankColor);
        }
        else {
            this.bankIndicator.value = selectedBank;
            this.bankColor.fromString(kNormalBankColor);
        }
        
    }
    paramChanged(param) 
    {
        if (param == this.bankList) 
        {
            this.assignment.selectedBank = this.bankList.value;
            this.updateBank(this.bankList.value);
            this.signalSyncDevice();
        }
        else if (param == this.assignModeParam) 
        {
            this.assignment.mode = this.assignModeParam.value;
            this.updateAssignment();
            this.signalSyncDevice();
        }
        else if (param == this.linkModeParam) 
        {
            this.determineEncoderMode();
            // this.updateEncoder();
            let enableMouseOver = (this.assignment.encoderMode == PanEncoderMode.kLinkEncoderMode);
            PreSonus.HostUtils.setParamMouseOverEnabled(enableMouseOver);
        }
        else if (param == this.lockEncoderParam) 
        {
            this.model.lockRecentParameter(param.value);
        }
        else if (param == this.bigEncoderModeParam) 
        {
            this.assignment.bigEncoderMode = param.value;
        }
    }
    onConnectFocusChannel() {
        super.onConnectFocusChannel();
        // if (this.assignment.isPlugEditModeWithFocus() == false) {
        //     this.updateBypassAlias();
        // }
        // if (this.assignment.encoderMode == PanEncoderMode.kChannelPanEncoderMode || PanEncoderMode.kChannelAudioClickMode) {
        //     this.determineEncoderMode();
        //     this.updateEncoder();
        // }
        // if (this.assignment.isSendVisible(FolderSlotIndex.kSlotAll) || this.assignment.isPlugOverview())
        //     this.updateChannel(0);
    }
    updatePanModeStatus() {
        if (this.assignment.isPanFocusMode())
            this.updateChannel(this.faderCount - 1);
    }
    updatePanModeControls() {
        if (this.assignment.isPanFocusMode())
            this.updateAllChannels();
    }
    onConnectChannel(channelIndex) {
        let channel = this.channels[channelIndex];
        channel.channelElement.connectAliasParam(channel.armValue, PreSonus.ParamID.kRecord);
        if (channel.channelElement.isConnected())
            channel.channelType = channel.channelElement.getProperty(PreSonus.PropertyID.kChannelType);
        else
            channel.channelType = kUndefinedChannelType;
        if (!(this.assignment.isPlugEditModeWithFocus() || this.assignment.mode == ChannelAssignmentMode.kMacroMode))
            this.updateChannel(channelIndex);
    }
    onConnectChannelSend(channelIndex, sendIndex) {
        if (this.assignment.isSendVisible(sendIndex + 1))
            this.updateChannel(channelIndex);
    }
    onConnectChannelCue(channelIndex, cueIndex) {
        if (this.assignment.isCueVisible(cueIndex + 1))
            this.updateChannel(channelIndex);
    }
    onConnectPlugMapping() {
        if (this.assignment.mode == ChannelAssignmentMode.kPlugMode) {
            let hasFocus = this.hasControlLinkFocus();
            if (this.assignment.controlLinkFocus != hasFocus) {
                this.assignment.controlLinkFocus = hasFocus;
                this.updateAssignment();
            }
        }
    }
    onConnectPlugControl(channelIndex) {
        if (this.assignment.mode == ChannelAssignmentMode.kPlugMode)
            this.updateChannel(channelIndex);
    }
    onConnectRecentParam() {

    }
    hasControlLinkFocus() {
        return this.plugBankElement.remapHint == PreSonus.RemapHint.kFocus;
    }
    getFocusChannelIndex() {
        if (!this.focusChannelElement.isConnected())
            return ChannelStrip.kInvalidChannelIndex;
        return this.channelBankElement.getBankChildIndex(this.focusChannelElement);
    }
    updateBypassAlias() {
        // if (this.assignment.isPlugEditModeWithFocus()) {
        //     this.plugBankElement.connectAliasParam(this.bypassAlias, PreSonus.ParamID.kFocusBypass);
        //     this.plugBankElement.connectAliasParam(this.autoModeAlias, PreSonus.ParamID.kFocusAutoMode);
        // }
        // else if (this.assignment.mode == ChannelAssignmentMode.kSendMode) {
        //     if (this.assignment.sendIndex == FolderSlotIndex.kSlotAll)
        //         this.focusChannelElement.connectAliasParam(this.bypassAlias, PreSonus.ParamID.kSendBypass);
        //     else {
        //         let sendIndex = this.assignment.sendIndex - 1;
        //         let sendSlotElement = this.focusSendsBankElement.getElement(sendIndex);
        //         sendSlotElement.connectAliasParam(this.bypassAlias, PreSonus.ParamID.kSendMute);
        //     }
        //     this.focusChannelElement.connectAliasParam(this.autoModeAlias, PreSonus.ParamID.kAutoMode);
        // }
        // else {
        //     this.focusChannelElement.connectAliasParam(this.bypassAlias, PreSonus.ParamID.kInsertBypass);
        //     this.focusChannelElement.connectAliasParam(this.autoModeAlias, PreSonus.ParamID.kAutoMode);
        // }
    }
    determineEncoderMode() {
        if (this.linkModeParam.value > 0) {
            this.assignment.encoderMode = PanEncoderMode.kLinkEncoderMode;
            return;
        }
        if (this.assignment.isPlugEditModeWithFocus()) {
            this.assignment.encoderMode = PanEncoderMode.kPlugEncoderMode;
            return;
        }
        if (this.focusChannelElement.isConnected()) {
            let channelType = this.focusChannelElement.getProperty(PreSonus.PropertyID.kChannelType);
            this.assignment.encoderMode = this.getEncoderModeForChannel(channelType);
        }
    }
    updateAssignment() {
        this.timeCodeMode.value = (this.assignment.mode == ChannelAssignmentMode.kTimeMode);
        this.updateAllChannels();
        this.determineEncoderMode();
    }
    onEncoderInput(channelIndex, value) 
    {
        let channel = this.channels[channelIndex];

        switch (this.assignment.mode) 
        {
            case ChannelAssignmentMode.kTrackMode:
                {
                    if (!channel.channelElement.isConnected())
                        return;
                    // let touchParamID = PreSonus.ParamID.kVolume;
                    // this.processFaderTouchForVolumeMode(channel, pressed, "Volume", touchParamID);
                    // this.processFaderReset(channel, pressed, shift);
                    break;
                }
            // case ChannelAssignmentMode.kInputGainMode:
            //     {
            //         if (!channel.channelElement.isConnected())
            //             return;
            //         if (!this.isInputGainSupportingChannel(channel.channelType))
            //             break;
            //         let touchParamID = PreSonus.ParamID.kInputFxGain;
            //         this.processFaderTouchForVolumeMode(channel, pressed, "Gain", touchParamID);
            //         this.processFaderReset(channel, pressed, shift);
            //         break;
            //     }
            default:
                // this.processFaderReset(channel, pressed, shift);
                break;
        }
    }
    onEncoderPushed(channelIndex, value) {
        if (!value)
            return;

        let channel = this.channels[channelIndex];

        channel.encoderValue.setValue(channel.encoderValue.default, true);
    }
    onConnectChannelMacroControl(controlIndex) {
        if (this.assignment.mode == ChannelAssignmentMode.kMacroMode)
            this.updateChannel(controlIndex);
    }
    onConnectFocusChannelInsert(insertIndex) {
        if (this.assignment.isPlugOverview())
            this.updateChannel(insertIndex);
    }
    onConnectFocusChannelSend(sendIndex) {
        if (this.assignment.isSendVisible(FolderSlotIndex.kSlotAll))
            this.updateChannel(sendIndex);
        else if (this.assignment.isSendVisible(sendIndex + 1))
            this.updateBypassAlias();
    }
    onConnectFocusChannelCue(cueIndex) {
        if (this.assignment.isCueVisible(FolderSlotIndex.kSlotAll))
            this.updateChannel(cueIndex);
    }
    onFaderTouched(channelIndex, value) 
    {
        let channel = this.channels[channelIndex];
        let pressed = value != 0;
        let shift = this.shiftPressedModifier.value;
        switch (this.assignment.mode) 
        {
            case ChannelAssignmentMode.kPanMode:
            case ChannelAssignmentMode.kSendMode:
            case ChannelAssignmentMode.kCueMode:
                {
                    if (!channel.channelElement.isConnected())
                        return;
                    let touchParamID = PreSonus.ParamID.kVolume;
                    this.processFaderTouchForVolumeMode(channel, pressed, "Volume", touchParamID);
                    this.processFaderReset(channel, pressed, shift);
                    break;
                }
            case ChannelAssignmentMode.kInputGainMode:
                {
                    if (!channel.channelElement.isConnected())
                        return;
                    if (!this.isInputGainSupportingChannel(channel.channelType))
                        break;
                    let touchParamID = PreSonus.ParamID.kInputFxGain;
                    this.processFaderTouchForVolumeMode(channel, pressed, "Gain", touchParamID);
                    this.processFaderReset(channel, pressed, shift);
                    break;
                }
            default:
                this.processFaderReset(channel, pressed, shift);
                break;
        }
    }
    processFaderTouchForVolumeMode(channel, pressed, title, touchParamId) 
    {
        if (pressed) 
        {
            this.faderTouchTitle.setValue(title);
            channel.displayMode.setValue(0, true);
            channel.setDisplayLine(2, channel.channelElement, touchParamId);
        }
        else 
        {
            channel.displayMode.setValue(this.assignment.mode, true);
            channel.setDisplayLine(2, channel.currentEncoderElement, channel.currentEncoderParam);
        }
    }
    processFaderReset(channel, pressed, shift) {
        if (pressed) 
        {
            channel.updateFaderLastTouched();
            return;
        }
        // if (shift) {
        //     let currentDate = new Date();
        //     let diffMs = Math.abs(channel.lastTouched.getTime() - currentDate.getTime());
        //     if (diffMs >= kFaderTapTimeoutMs)
        //         return;
        //     channel.restoreFaderDefaultValue();
        // }
    }
    saveBigEncoderMode() {
        if (this.assignment.previousBigEncoderMode != BigEncoderMode.kInvalidBigEncoderMode)
            return;
        this.assignment.previousBigEncoderMode = this.assignment.bigEncoderMode;
    }
    restoreBigEncoderMode() {
        if (this.assignment.previousBigEncoderMode == BigEncoderMode.kInvalidBigEncoderMode)
            return;
        this.bigEncoderModeParam.setValue(this.assignment.previousBigEncoderMode, true);
        this.assignment.previousBigEncoderMode = BigEncoderMode.kInvalidBigEncoderMode;
    }
    onFunctionButtonPressed(value) {
        if (!value)
            return;
        if (this.shiftModifer.value)
            return;
        if (!this.assignment.isBigEncoderOverlayMode())
            return;
        this.assignment.previousBigEncoderMode = BigEncoderMode.kInvalidBigEncoderMode;
        this.assignModeParam.setValue(ChannelAssignmentMode.kTrackMode, true);
    }
    onTrackButtonPressed(value) 
    {       
        if (!value)
            return;
        if (this.assignment.mode != ChannelAssignmentMode.kTrackMode)
            return;

        this.updateAssignment();
        this.signalSyncDevice();
    }
    onPanButtonPressed(value) 
    {       
        if (!value)
            return;
        if (this.assignment.mode != ChannelAssignmentMode.kPanMode) 
            this.assignModeParam.setValue(ChannelAssignmentMode.kPanMode, true);
        else
            this.assignModeParam.setValue(ChannelAssignmentMode.kTrackMode, true);
        
        this.updateAssignment();
        this.signalSyncDevice();
    }
    onPlugButtonPressed(value) 
    {
        if (!value)
            return;
        if (this.assignment.mode != ChannelAssignmentMode.kPlugMode) 
            this.assignModeParam.setValue(ChannelAssignmentMode.kPlugMode, true);
        else
            this.assignModeParam.setValue(ChannelAssignmentMode.kTrackMode, true);

        this.updateAssignment();
        this.signalSyncDevice();
    }
    onSendButtonPressed(value) {
        if (!value)
            return;
        if (this.assignment.mode != ChannelAssignmentMode.kSendMode) 
            this.assignModeParam.setValue(ChannelAssignmentMode.kSendMode, true);
        else
            this.assignModeParam.setValue(ChannelAssignmentMode.kTrackMode, true);

        this.updateAssignment();
        this.signalSyncDevice();
    }
    onEQButtonPressed(value) {
        if (!value)
            return;
        if (this.assignment.mode != ChannelAssignmentMode.kCueMode) 
            this.assignModeParam.setValue(ChannelAssignmentMode.kCueMode, true);
        else
            this.assignModeParam.setValue(ChannelAssignmentMode.kTrackMode, true);

        this.updateAssignment();
        this.signalSyncDevice();
    }
    setChannelSelectMode(index, mode) {
        let channel = this.channels[index];
        if (mode != channel.lastSelectMode) {
            channel.lastSelectMode = mode;
            let channelElement = channel.channelElement;
            if (channelElement.isAliasConnected(channel.selectValue, PreSonus.ParamID.kSelect))
                channelElement.setParamMode(PreSonus.ParamID.kSelect, mode);
        }
    }
    onSelectButtonBeginMode(index, value) {
        if (value) {
            if (this.shiftModifer.value)
                this.setChannelSelectMode(index, PreSonus.ParamID.kMultiSelectMode);
        }
    }
    onSelectButtonPressed(index, value) {
        if (value) {
            if (this.assignment.isPlugOverview()) {
                let element = this.channels[index].insertSlotElement;
                if (!element.isConnected())
                    return;
                PreSonus.HostUtils.openEditorAndFocus(this, element);
                if (this.hasControlLinkFocus() && !this.assignment.controlLinkFocus) {
                    this.assignment.controlLinkFocus = true;
                    this.updateAssignment();
                }
            }
            else {
                let channel = this.channels[index];
                let channelElement = channel.channelElement;
                if (channelElement.isAliasConnected(channel.selectValue, PreSonus.ParamID.kSelect)) {
                    if (channelElement.getParamValue(PreSonus.ParamID.kSelect))
                        PreSonus.HostUtils.makeChannelVisible(channelElement);
                }
            }
        }
        else {
            this.setChannelSelectMode(index, "");
        }
    }
    scrollChannelBank(direction) {
        let placementBankPageSize = this.root.getPlacementGroupSize();
            let stepSize = (placementBankPageSize == 0) ?
                this.channelBankElement.pageSize : placementBankPageSize;
            this.channelBankElement.scroll(stepSize * direction);
        // let mode = this.assignment.bigEncoderMode;
        // if (mode == BigEncoderMode.kChannelMode) {
        //     let stepSize = 1;
        //     this.channelBankElement.scroll(stepSize * direction);
        // }
        // else if (mode == BigEncoderMode.kBankMode || mode == BigEncoderMode.kMasterMode) {
        //     let placementBankPageSize = this.root.getPlacementGroupSize();
        //     let stepSize = (placementBankPageSize == 0) ?
        //         this.channelBankElement.pageSize : placementBankPageSize;
        //     this.channelBankElement.scroll(stepSize * direction);
        // }
    }
    onPrevButtonPressed(value) {
        if (!value)
            return;

        this.scrollChannelBank(ScrollDirection.kLeft);
        // switch (this.assignment.bigEncoderMode) {
        //     case BigEncoderMode.kPanSelectMode:
        //         this.prevPanStereoMode();
        //         break;
        //     default:
        //         this.scrollChannelBank(ScrollDirection.kLeft);
        //         break;
        // }
    }
    onNextButtonPressed(value) {
        if (!value)
            return;

        this.scrollChannelBank(ScrollDirection.kRight);
        // switch (this.assignment.bigEncoderMode) {
        //     case BigEncoderMode.kPanSelectMode:
        //         this.nextPanStereoMode();
        //         break;
        //     default:
        //         this.scrollChannelBank(ScrollDirection.kRight);
        //         break;
        // }
    }
    onBigEncoderPushed(value) {
        if (!value)
            return;
        let mode = this.assignment.bigEncoderMode;
        if (mode == BigEncoderMode.kChannelMode || mode == BigEncoderMode.kBankMode) {
            let channelIndex = this.getFocusChannelIndex();
            if (channelIndex != ChannelStrip.kInvalidChannelIndex) {
                let stripCount = this.root.getPlacementGroupSize();
                if (stripCount == 0)
                    stripCount = this.faderCount;
                let position = Math.floor(channelIndex / stripCount) * stripCount;
                this.channelBankElement.scrollTo(position);
            }
        }
    }
    determineSlotIndex(folder, currentSlotIndex) {
        let maxSlots = this.faderCount;
        if (this.mixerMapping.component)
            maxSlots = this.mixerMapping.invokeChildMethod("audioMixer", "getMaxSlotCount", folder);
        let nextSlotIndex = currentSlotIndex + 1;
        if (nextSlotIndex >= FolderSlotIndex.kSlotFirst + this.faderCount ||
            nextSlotIndex >= FolderSlotIndex.kSlotFirst + maxSlots) {
            nextSlotIndex = FolderSlotIndex.kSlotAll;
        }
        return nextSlotIndex;
    }
    processSendsMode() {
        let sendIndex = this.determineSlotIndex(PreSonus.FolderID.kSendsFolder, this.assignment.sendIndex);
        if (sendIndex == this.assignment.sendIndex)
            return;
        this.assignment.sendIndex = sendIndex;
    }
    processCuesMode() {
        let cueIndex = this.determineSlotIndex(PreSonus.FolderID.kCueMixFolder, this.assignment.cueIndex);
        if (cueIndex == this.assignment.cueIndex)
            return;
        this.assignment.cueIndex = cueIndex;
    }   
    updateAllChannels() {
        for (let i = 0; i < this.faderCount; i++)
            this.updateChannel(i);
    }
    updateChannel(channelIndex) {
        let channel = this.channels[channelIndex];
        let mode = this.assignment.mode;

        let faderParameter;
        let faderElement = channel.channelElement;
        switch (mode) {
            case ChannelAssignmentMode.kInputGainMode:
                faderParameter = PreSonus.ParamID.kInputFxGain;
                break;
            case ChannelAssignmentMode.kTrackMode:
            default:
                faderParameter = PreSonus.ParamID.kVolume;
        }

        if (mode == ChannelAssignmentMode.kMacroMode) 
        {
            channel.clearDisplayLine(1);
            if (channel.macroFloatElement) 
            {
                channel.setDisplayLine(2, channel.macroFloatElement, PreSonus.ParamID.kMacroTitle);
                // channel.setDisplayLine(3, channel.macroFloatElement, PreSonus.ParamID.kMacroValue);
                channel.setDisplayValue(channel.macroFloatElement, PreSonus.ParamID.kMacroValue);
                channel.setFaderValue(channel.macroFloatElement, PreSonus.ParamID.kMacroValue);
            }
            else 
            {
                channel.clearDisplayLine(2);
                // channel.clearDisplayLine(3);
                channel.clearDisplayValue();
                channel.clearFaderValue();
            }
            if (channel.macroBoolElement) 
            {
                channel.setDisplayLine(0, channel.macroBoolElement, PreSonus.ParamID.kMacroTitle);
                channel.setSelectValue(channel.macroBoolElement, PreSonus.ParamID.kMacroValue);
                channel.trackColor.setOriginal(this.plugEditColor);
            }
            else 
            {
                channel.clearDisplayLine(0);
                channel.clearSelectValue();
                channel.clearSelectColor();
            }
        }
        else if (mode == ChannelAssignmentMode.kCueMode) 
        {
            let cueSlotElement = null;
            let slotInfoLine = 3;

            cueSlotElement = this.focusCuesBankElement.getElement(channelIndex);

            channel.setDisplayLine(0, cueSlotElement, PreSonus.ParamID.kCueMixDestination);
            channel.setDisplayLine(2, cueSlotElement, PreSonus.ParamID.kCueMixLevel);

            channel.currentEncoderElement = cueSlotElement;
            channel.currentEncoderParam = PreSonus.ParamID.kCueMixLevel;
        }
        else if (mode == ChannelAssignmentMode.kPlugMode) 
        {
            channel.setDisplayLine(0, channel.plugEncoderElement, PreSonus.ParamID.kTitle);
            channel.setDisplayLine(2, channel.plugEncoderElement, PreSonus.ParamID.kValue);

            // channel.plugFaderElement = this.plugBankElement.find("fader[" + i + "]");
            // channel.plugEncoderElement = this.plugBankElement.find("Encoder[" + i + "]");
            // channel.plugButtonElement = this.plugBankElement.find("PushEncoder[" + i + "]");

            faderElement = channel.plugFaderElement;
            faderParameter = PreSonus.ParamID.kValue;

            channel.currentEncoderElement = channel.plugEncoderElement;
            channel.currentEncoderParam = PreSonus.ParamID.kValue;

            // if (channelIndex == this.pagingStatusIndex)
            //     channel.lines[0].setOriginal(this.pagingStatusParam);

            // }
        }
        else if (mode == ChannelAssignmentMode.kSendMode) 
        {
            let sendSlotElement = null;

            sendSlotElement = this.focusSendsBankElement.getElement(channelIndex);

            if (sendSlotElement == null)
                return;

            channel.setDisplayLine(0, sendSlotElement, PreSonus.ParamID.kSendPort);
            channel.setDisplayLine(2, sendSlotElement, PreSonus.ParamID.kSendLevel);
            channel.setSelectValue(channel.channelElement, PreSonus.ParamID.kSelect);
            channel.setTrackColor(channel.channelElement, PreSonus.ParamID.kColor);

            channel.currentEncoderElement = sendSlotElement;
            channel.currentEncoderParam = PreSonus.ParamID.kSendLevel;
        }
        else if (mode == ChannelAssignmentMode.kTimeMode) 
        {
            channel.clearDisplayLine(0);
            channel.clearDisplayLine(1);
            channel.setDisplayLine(2, channel.channelElement, PreSonus.ParamID.kLabel);
            channel.setSelectValue(channel.channelElement, PreSonus.ParamID.kSelect);
            channel.setTrackColor(channel.channelElement, PreSonus.ParamID.kColor);
            channel.setFaderValue(channel.channelElement, PreSonus.ParamID.kVolume);
        }
        else if (mode == ChannelAssignmentMode.kPanMode)
        {
            channel.setDisplayLine(0, channel.channelElement, PreSonus.ParamID.kLabel);
            channel.setDisplayLine(1, channel.channelElement, PreSonus.ParamID.kNumber);
            channel.setDisplayLine(2, channel.channelElement, PreSonus.ParamID.kPan);
            channel.setSelectValue(channel.channelElement, PreSonus.ParamID.kSelect);
            channel.setTrackColor(channel.channelElement, PreSonus.ParamID.kColor);
            let faderParameter;
            switch (mode) {
                case ChannelAssignmentMode.kInputGainMode:
                    faderParameter = PreSonus.ParamID.kInputFxGain;
                    break;
                case ChannelAssignmentMode.kTrackMode:
                default:
                    faderParameter = PreSonus.ParamID.kVolume;
            }

            channel.currentEncoderElement = channel.channelElement;
            channel.currentEncoderParam = PreSonus.ParamID.kPan;
        }
        else 
        {
            channel.setDisplayLine(0, channel.channelElement, PreSonus.ParamID.kLabel);
            channel.setDisplayLine(1, channel.channelElement, PreSonus.ParamID.kNumber);
            channel.setDisplayLine(2, channel.channelElement, PreSonus.ParamID.kVolume);
            channel.setSelectValue(channel.channelElement, PreSonus.ParamID.kSelect);
            channel.setTrackColor(channel.channelElement, PreSonus.ParamID.kColor);
            let faderParameter;
            switch (mode) {
                case ChannelAssignmentMode.kInputGainMode:
                    faderParameter = PreSonus.ParamID.kInputFxGain;
                    break;
                case ChannelAssignmentMode.kTrackMode:
                default:
                    faderParameter = PreSonus.ParamID.kVolume;
            }

            channel.currentEncoderElement = channel.channelElement;
            channel.currentEncoderParam = PreSonus.ParamID.kPan;
        }

        channel.setFaderValue(faderElement, faderParameter);
        channel.setEncoderValue(channel.currentEncoderElement, channel.currentEncoderParam)
        channel.displayMode.setValue(mode, true);

        let placementBankPageSize = this.root.getPlacementGroupSize();
        // this.log("total size: " + placementBankPageSize 
        // + "   faders: " + this.faderCount 
        // + "   pagesize:" + this.channelBankElement.pageSize 
        // + "   group:" + this.root.getPlacementGroup() 
        // + ".");
    }
    static buildSlotInfo(name, slotNumber) {
        return "[" + name + " " + slotNumber + "]";
    }
    onShiftButtonPressed(state) {
        this.shiftPressedModifier.setValue(state);
    }
    isPanSupportingChannel(channelType) {
        return channelType != PreSonus.ChannelType.kAudioOutput
            && channelType != PreSonus.ChannelType.kAudioListenBus;
    }
    isSendsSupportingChannel(channelType) {
        return channelType != PreSonus.ChannelType.kAudioOutput
            && channelType != PreSonus.ChannelType.kAudioListenBus
            && channelType != PreSonus.ChannelType.kAudioEffect;
    }
    isCuesSupportingChannel(channelType) {
        return channelType == PreSonus.ChannelType.kAudioTrack
            || channelType == PreSonus.ChannelType.kAudioSynth
            || channelType == PreSonus.ChannelType.kAudioAux;
    }
    isInputGainSupportingChannel(channelType) {
        return channelType != PreSonus.ChannelType.kAudioOutput &&
            channelType != PreSonus.ChannelType.kAudioListenBus;
    }
    getEncoderValueParamID(channelType) {
        if (this.isPanSupportingChannel(channelType))
            return PreSonus.ParamID.kPan;
        else
            return PreSonus.ParamID.kAudioClickGain;
    }
    getEncoderModeForChannel(channelType) {
        if (this.isPanSupportingChannel(channelType))
            return PanEncoderMode.kChannelPanEncoderMode;
        else
            return PanEncoderMode.kChannelAudioClickMode;
    }
}

function createAspComponentInstance() 
{
    return new AspComponent(8);
}