var Asp;
(function (Asp) {
    Asp.kActiveSensingTimeout = 5000;
    let DisplayMode;
    (function (DisplayMode) {
        DisplayMode[DisplayMode["kDefault"] = 0] = "kDefault";
        DisplayMode[DisplayMode["kAltMode"] = 1] = "kAltMode";
        DisplayMode[DisplayMode["kAltSmallMode"] = 2] = "kAltSmallMode";
        DisplayMode[DisplayMode["kAltLargeMode"] = 3] = "kAltLargeMode";
        DisplayMode[DisplayMode["kMeterMode"] = 4] = "kMeterMode";
        DisplayMode[DisplayMode["kMeterMode2"] = 5] = "kMeterMode2";
        DisplayMode[DisplayMode["kNumModes"] = 6] = "kNumModes";
    })(DisplayMode = Asp.DisplayMode || (Asp.DisplayMode = {}));
    let TextStyle;
    (function (TextStyle) {
        TextStyle[TextStyle["kCenter"] = 0] = "kCenter";
        TextStyle[TextStyle["kLeft"] = 1] = "kLeft";
        TextStyle[TextStyle["kRight"] = 2] = "kRight";
        TextStyle[TextStyle["kInvert"] = 4] = "kInvert";
    })(TextStyle = Asp.TextStyle || (Asp.TextStyle = {}));
    let ValueBar;
    (function (ValueBar) {
        ValueBar[ValueBar["kNormal"] = 0] = "kNormal";
        ValueBar[ValueBar["kPan"] = 1] = "kPan";
        ValueBar[ValueBar["kFill"] = 2] = "kFill";
        ValueBar[ValueBar["kSpread"] = 3] = "kSpread";
        ValueBar[ValueBar["kOff"] = 4] = "kOff";
    })(ValueBar = Asp.ValueBar || (Asp.ValueBar = {}));
    class Support 
    {
        static scaleMeter(value) 
        {
            return (value * Support.kMaxMeter);
        }
        static buildDisplayTextEncoderFunctionSysex(sysexBuffer, displayId, length, text) 
        {
            sysexBuffer.begin(Support.kSysexHeaderAsp);
            sysexBuffer.push(0x19);
            sysexBuffer.push(displayId * 8);
            sysexBuffer.appendAscii(text);

            for (let idx = text.length; idx < length; idx++) 
            {
                sysexBuffer.appendAscii(0x20);
            }

            sysexBuffer.end();
            return sysexBuffer;
        }
        static buildDisplayTextSysex(sysexHeader, sysexBuffer, displayId, lineId, length, text) 
        {
            if (lineId == 2)
                lineId = 1;

            sysexBuffer.begin(sysexHeader);
            sysexBuffer.push(0x1A);
            sysexBuffer.push(displayId * 12);
            sysexBuffer.push(lineId + 1);
            sysexBuffer.appendAscii(text);

            for (let idx = text.length; idx < length; idx++) 
            {
                sysexBuffer.appendAscii(0x20);
            }

            sysexBuffer.end();
            return sysexBuffer;
        }
    }
    Support.kTextStyle = "textStyle";
    Support.kMaxMeter = 12; //0x7F;
    Support.kMaxLineCount = 4;
    Support.kSysexHeaderAsp = [0x00, 0x00, 0x66, 0x14];
    Asp.Support = Support;
})(Asp || (Asp = {}));
