load("Dxxx_display.js");
load("Dxxx_encoders.js");
load("Dxxx_var.js");


//
// # D700 Extension
//


var trackNosVisible = true;


function Extension(extensionID)
{
    this.extensionID = extensionID;
    this.displayStrip = new DisplayStrip(extensionID);
    this.encoderStrip = new EncoderStrip(extensionID);  
}

Extension.prototype.showPage = function(page)
{
	if (page == DISPLAY_PAGES.FX)
	{
		this.displayStrip.activeFXDev = fxDevPosition;
		this.displayStrip.activeFXPage = this.GetFXPage();
		this.encoderStrip.activeFXDev = fxDevPosition;
		this.encoderStrip.activeFXPage = this.GetFXPage();
	}
	else if (page == DISPLAY_PAGES.EQ && eqDevPosition != -1)
	{
		this.displayStrip.activeFXDev = eqDevPosition;
		this.displayStrip.activeFXPage = this.GetEQPage();
		this.encoderStrip.activeFXDev = eqDevPosition;
		this.encoderStrip.activeFXPage = this.GetEQPage();
	}
	else
	{
		this.displayStrip.activeFXDev = -1;
		this.displayStrip.activeFXPage = -1;
		this.encoderStrip.activeFXDev = -1;
		this.encoderStrip.activeFXPage = -1;
	}
	
	this.displayStrip.showPage(page);
	this.encoderStrip.showPage(page);
}

Extension.prototype.unshowPage = function(page)
{
	this.encoderStrip.unshowPage(page);
}

Extension.prototype.GetFXPage = function()
{
	var devPageCntDmy = devicesFromSelectedTrackRemotePage[fxDevPosition][0].pageCount().get();
	var fxPageDmy = fxDevPageOffset + this.extensionID;

	if (fxPageDmy >= devPageCntDmy)
		return -1;

	return fxPageDmy;
}

Extension.prototype.GetEQPage = function()
{
	var devPageCntDmy = devicesFromSelectedTrackRemotePage[eqDevPosition][0].pageCount().get();
	var eqPageDmy = eqDevPageOffset + this.extensionID;

	if (eqPageDmy >= devPageCntDmy)
		return -1;

	return eqPageDmy;
}


function unshowPage()
{
	if (activePage != -1)
	{
		for (var exNo = 0; exNo < extensionCount; exNo++)
		{
			this.Extensions[exNo].unshowPage(activePage);
		}  
	}
}

function showPage(page)
{
    if (activePage == page && page != VPOT_PAGE.EQ && page != VPOT_PAGE.FX)
        return;

	if (activePage != -1)
	{
		for (var exNo = 0; exNo < extensionCount; exNo++)
		{
			this.Extensions[exNo].unshowPage(activePage);
		}  
	}

    lastActivePage = activePage;
    activePage = page;
    trackNosVisible = true;

    if (page == VPOT_PAGE.TRACK)	
	{
		sendNoteOn(0, VPOT_ASSIGN.EQ, 0);
		sendNoteOn(0, VPOT_ASSIGN.SEND, 0);
		sendNoteOn(0, VPOT_ASSIGN.PAN, 0);
		sendNoteOn(0, VPOT_ASSIGN.FX, 0);
		setDisplayEncoderFunctionForPage(page, " ");
	}
	else if (page == VPOT_PAGE.PAN)	
	{
		sendNoteOn(0, VPOT_ASSIGN.EQ, 0);
		sendNoteOn(0, VPOT_ASSIGN.SEND, 0);
		sendNoteOn(0, VPOT_ASSIGN.PAN, 127);
		sendNoteOn(0, VPOT_ASSIGN.FX, 0);
		setDisplayEncoderFunctionForPage(page, "Pan");
	}
	else if (page == VPOT_PAGE.FX)	
	{
		sendNoteOn(0, VPOT_ASSIGN.EQ, 0);
		sendNoteOn(0, VPOT_ASSIGN.SEND, 0);
		sendNoteOn(0, VPOT_ASSIGN.PAN, 0);
		sendNoteOn(0, VPOT_ASSIGN.FX, 127);
        trackNosVisible = false;
	}
	else if (page == VPOT_PAGE.EQ)	
	{
		sendNoteOn(0, VPOT_ASSIGN.EQ, 127);
		sendNoteOn(0, VPOT_ASSIGN.SEND, 0);
		sendNoteOn(0, VPOT_ASSIGN.PAN, 0);
		sendNoteOn(0, VPOT_ASSIGN.FX, 0);
	}
	else if (page == VPOT_PAGE.SEND0 || page == VPOT_PAGE.SEND1 || page == VPOT_PAGE.SEND2 || page == VPOT_PAGE.SEND3 || page == VPOT_PAGE.SEND4)	
	{
		sendNoteOn(0, VPOT_ASSIGN.EQ, 0);
		sendNoteOn(0, VPOT_ASSIGN.SEND, 127);
		sendNoteOn(0, VPOT_ASSIGN.PAN, 0);
		sendNoteOn(0, VPOT_ASSIGN.FX, 0);
		setDisplayEncoderFunctionForPage(page, "Send " + (page - VPOT_PAGE.SEND0 + 1));
	}	

	if (page != VPOT_PAGE.EQ && page != VPOT_PAGE.FX)
	{
		eqDevPageOffset = 0;
		fxDevPosition = 0;
		fxDevPageOffset = 0;
	}

    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        this.Extensions[exNo].showPage(page);
    }  
}

