load("Dxxx_display.js");
load("Dxxx_encoders.js");
load("Dxxx_var.js");
load("Dxxx_shared.js");
load("D700_extension.js");


// TODO
// color encoders in FX mode ... not possible for now?
// clipping doesn't exist in bitwig?


//
// # Main File
//


var additionalExes = extensionCount - 1;

var isShiftPressed = false;
var isResetPressed = false;
var isScrubPressed = false;
var isPlay = false;

var faderTouchSelectsChannel = true;
var faderTouchSelectsChannelSetting;
var vuEnabled = true;
var vuEnabledSetting;
var hasDisplay = true;
var magicActionID = 0;
var hasDisplaySetting;
var actionsListForSettings;

var activeDisplayPage = DISPLAY_PAGES.NAME_AND_VOLUME;
var activeSendPage = VPOT_PAGE.SEND0;
var activeDevicePage = VPOT_PAGE.FX;
var parameterPageBuffer = -1;
var parameterPageBuffer = 0;
var vuMeterLastSend = [];
var selectedTrack = 0;
var numSendPages = 5;

var eqDevPositionLast = -1;
var eqDevPosition = 0;
var eqDevPageOffset = 0;
var fxDevPosition = 0;
var fxDevPageOffset = 0;

var activePage = -1;
var lastActivePage = -1;

var Extensions = [];
var FXEncoderPages = [];
var FXDisplayPages = [];
var FXPagesCount = 20;
var FXPagesPerDevCount = 8;

var devicesFromSelectedTrack = [];
var devicesFromSelectedTrackRemotePage = [];

var automationWrite = false;
var automationWriteMode = "";

var preferences;

function init()
{
    printText("####################################################");
    printText("Initializing");

    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        Extensions[exNo] = new Extension(exNo);
    }
 
    //
    // # Host
    //

    host.getMidiInPort(0).setMidiCallback(onMidiMainDev); // Main dev

    if (extensionCount >= 2)
        host.getMidiInPort(1).setMidiCallback(onMidiExtension1);

    if (extensionCount >= 3)
        host.getMidiInPort(2).setMidiCallback(onMidiExtension2);

    if (extensionCount >= 4)
        host.getMidiInPort(3).setMidiCallback(onMidiExtension3);

    if (extensionCount >= 5)
        host.getMidiInPort(4).setMidiCallback(onMidiExtension4);

    if (extensionCount >= 6)
        host.getMidiInPort(5).setMidiCallback(onMidiExtension5);

    if (extensionCount >= 7)
        host.getMidiInPort(6).setMidiCallback(onMidiExtension6);

    if (extensionCount >= 8)
        host.getMidiInPort(7).setMidiCallback(onMidiExtension7);

    application = host.createApplication();

    // cursor is the selected stuff
    cursorTrack = host.createCursorTrack(0, 1);
    cursorDevice = cursorTrack.createCursorDevice('cDev1', 'cDev1', extensionCount * 8, CursorDeviceFollowMode.FOLLOW_SELECTION);
    cursorRemotePage = cursorDevice.createCursorRemoteControlsPage('cRCPage1', 8,'');
    cursorRemotePage.pageCount().markInterested();
    cursorRemotePage.selectedPageIndex().markInterested();

    selectedTrack = host.createCursorTrack(1, "selectedTrack", 2, 0, true);
    masterTrack = host.createMasterTrack(0);
    trackBank = host.createTrackBank(8 * extensionCount, numSendPages, 99);

    transport = host.createTransport();

    // Devices are all the plugins
    deviceBank = cursorTrack.createDeviceBank(FXPagesCount);
    deviceBank.itemCount().markInterested();

    for (var i = 0; i < FXPagesCount; i++)
    {
        devicesFromSelectedTrack[i] = deviceBank.getItemAt(i);
        devicesFromSelectedTrack[i].name().markInterested();

        FXEncoderPages[i] = [];
        FXDisplayPages[i] = [];

        devicesFromSelectedTrackRemotePage[i] = [];

        for (var j = 0; j < FXPagesPerDevCount; j++) // pages inside device
        {
            FXEncoderPages[i][j] = new EncoderPage();
            FXDisplayPages[i][j] = new DisplayPage();

            devicesFromSelectedTrackRemotePage[i][j] = devicesFromSelectedTrack[i].createCursorRemoteControlsPage('cRCPageD' + (i * 8 + j), 8,'');
            devicesFromSelectedTrackRemotePage[i][j].pageCount().markInterested();

            devicesFromSelectedTrack[i].addNameObserver(SINGLE_DISPLAY_WIDTH, "", makeDoubleIndexedFunction(i, j, function(devNo, pageNo, value)
            {
                FXDisplayPages[devNo][pageNo].setDisplayText(7, 0, value);
                refreshFXDisplayPageLine(devNo, pageNo, 2);
            }));
 
            for (var t = 0; t < 8; t++) // 8 parameters each
            {
                devicesFromSelectedTrackRemotePage[i][j].getParameter(t).addNameObserver(SINGLE_DISPLAY_WIDTH_THIRD, "", makeTripleIndexedFunction(i, j, t, function(devNo, pageNo, paramNo, value)
                {
                    if (pageNo >= devicesFromSelectedTrackRemotePage[devNo][pageNo].pageCount().get())
                        return;

                    //printText("............... dev: " + devNo + " page: " + pageNo + " param: " + paramNo + " name: " + value + "     pageCnt:" + devicesFromSelectedTrackRemotePage[devNo][pageNo].pageCount().get());

                    FXDisplayPages[devNo][pageNo].setDisplayText(paramNo, 2, value);
                    refreshFXDisplayPageLine(devNo, pageNo, 2);
                }));

                devicesFromSelectedTrackRemotePage[i][j].getParameter(t).value().addValueObserver(128, makeTripleIndexedFunction(i, j, t, function(devNo, pageNo, paramNo, value)
                {
                    if (pageNo >= devicesFromSelectedTrackRemotePage[devNo][pageNo].pageCount().get())
                        return;

                    FXEncoderPages[devNo][pageNo].newValue(paramNo, value, 1);
                    refreshFXEncoderPage(devNo, pageNo);
                }));
        
                devicesFromSelectedTrackRemotePage[i][j].getParameter(t).addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeTripleIndexedFunction(i, j, t, function(devNo, pageNo, paramNo, value)
                {
                    if (pageNo >= devicesFromSelectedTrackRemotePage[devNo][pageNo].pageCount().get())
                        return;

                    FXDisplayPages[devNo][pageNo].setDisplayText(paramNo, 1, value);
                    refreshFXDisplayPageLine(devNo, pageNo, 1);
                }));
            }
        }

        devicesFromSelectedTrackRemotePage[i][0].pageCount().addValueObserver(makeIndexedFunction(i, function(index, value)
        {
            for (var j = 0; j < FXPagesPerDevCount; j++)
            {
                devicesFromSelectedTrackRemotePage[index][j].selectedPageIndex().set(j);
            }
        }));
    }

    deviceBank.addDeviceCountObserver(function (value)
    {
        refreshEQPosition();
        checkPageStillValid();
        showPage(activePage);
    });

    cursorTrack.position().addValueObserver(function (value)
    {
        refreshEQPosition();
        checkPageStillValid();
        showPage(activePage);
    }, 0);


    //
    // # Settings
    //

    preferences = host.getPreferences();
    faderTouchSelectsChannelSetting = preferences.getBooleanSetting("Fader touch selects channel", "Faders", true);

    faderTouchSelectsChannelSetting.addValueObserver(function(value)
    {
        faderTouchSelectsChannel = value;
    });

    vuEnabledSetting = preferences.getBooleanSetting("VU metering enabled", "Display", true);

    vuEnabledSetting.addValueObserver(function(value)
    {
        vuEnabled = value;
    });

    hasDisplaySetting = preferences.getBooleanSetting("Display attached", "Display", true);

    hasDisplaySetting.addValueObserver(function(value)
    {
        hasDisplay = value;
    });

    // Do via settings shortcuts instead of this
    // var settingsStringArr = [];
    // actionsListForSettings = application.getActions();
    
    // for (var i = 0; i < actionsListForSettings.length; i++)
    //     settingsStringArr[i] = actionsListForSettings[i].getName();

    // hasDisplaySetting = preferences.getEnumSetting("Magic * Action", "Knobs", settingsStringArr, actionsListForSettings[0].getName());

    // hasDisplaySetting.addValueObserver(function(value)
    // {
    //     magicActionID = actionsListForSettings[0].getId();

    //     for (var i = 0; i < actionsListForSettings.length; i++)
    //     {
    //         if (actionsListForSettings[i].getName() == value)
    //         {
    //             magicActionID = actionsListForSettings[i].getId();
    //             break;
    //         }
    //     }
    // });


    //
    // # Selected Track
    //

    cursorTrack.addNameObserver(SINGLE_DISPLAY_WIDTH, "", function(value) // Display text, name
    {
        for (var i = 0; i < FXPagesCount; i++)
        {
            for (var j = 0; j < FXPagesPerDevCount; j++)
            {
                FXDisplayPages[i][j].setDisplayText(0, 0, value);
                refreshFXDisplayPageLine(i, j, 0);
            }
        }
    });


    //
    // # Transport
    //

    transport.addIsPlayingObserver(function(on)
    {
        isPlay = on;
        sendNoteOn(0, TRANSPORT.PLAY, on ? 127 : 0);
        sendNoteOn(0, TRANSPORT.STOP, on ? 0 : 127);
    });

    transport.addIsLoopActiveObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.CYCLE, on ? 127 : 0);
    });

    transport.addIsRecordingObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.RECORD, on ? 127 : 0);
    });

    transport.addIsWritingArrangerAutomationObserver(function(on)
    {
        automationWrite = on;
    });

    transport.addIsWritingClipLauncherAutomationObserver(function(on)
    {
        sendNoteOn(0, AUTOMATION.TRIM, on ? 127 : 0);
    });

    transport.addAutomationOverrideObserver(function(on)
    {
        sendNoteOn(0, AUTOMATION.GROUP, on ? 127 : 0);
    });

    transport.addClickObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.CLICK, on ? 127 : 0);
    });

    transport.addOverdubObserver(function(on)
    {
        sendNoteOn(0, TRANSPORT.REPLACE, on ? 127 : 0);
    });


    //
    // # Track Bank, Extensions, DxxxF
    //

    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        for (var t = 0; t < 8; t++)
        {
            var trackNo = t + exNo * 8;
            var track = trackBank.getTrack(trackNo);
            
            track.addNameObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value) // Display text, names
            {
                writeText(DISPLAY_PAGES.NAME_AND_VOLUME, index, 0, value);
                writeText(DISPLAY_PAGES.NAME_AND_PAN,    index, 0, value);
                writeText(DISPLAY_PAGES.NAME_AND_SEND0,  index, 0, value);
                writeText(DISPLAY_PAGES.NAME_AND_SEND1,  index, 0, value);
                writeText(DISPLAY_PAGES.NAME_AND_SEND2,  index, 0, value);
                writeText(DISPLAY_PAGES.NAME_AND_SEND3,  index, 0, value);
                writeText(DISPLAY_PAGES.NAME_AND_SEND4,  index, 0, value);
            }));

            track.addPositionObserver(makeIndexedFunction(trackNo, function(index, value) // Fader positions
            {
                showDisplayTrackNo(index, value + 1); // track no
            }));

            track.volume().addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value) // Display text, db vals
            {
                writeText(DISPLAY_PAGES.NAME_AND_VOLUME, index, 1, value);
            }));
        
            getMidiPortByEx(exNo).sendMidi(MIDIMSGTYPES.CHANNELPRESSURE,  0xf + (t << 4), 0); // reset peak hold

            vuMeterLastSend[trackNo] = [];
            vuMeterLastSend[trackNo][0] = new Date().valueOf() - 5000;
            vuMeterLastSend[trackNo][1] = new Date().valueOf() - 5000;

            track.addVuMeterObserver(12, 0, true, makeIndexedFunction(trackNo, function(index, vuMeter)
            {
                if (vuEnabled && isPlay) // Display VU meters
                {
                    var milliseconds = new Date().valueOf();

                    if (vuMeterLastSend[index][0] < milliseconds - 200) // limit updates to 5 FPS
                    {
                        getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.CHANNELPRESSURE, parseInt(vuMeter) + (trackNoToTrackNo(index) << 4), 0);
                        vuMeterLastSend[index][0] = milliseconds; // millisecs
                    }  
                }
            }));

            track.addVuMeterObserver(12, 1, true, makeIndexedFunction(trackNo, function(index, vuMeter)
            {
                if (vuEnabled && isPlay) // Display VU meters
                {
                    var milliseconds = new Date().valueOf();

                    if (vuMeterLastSend[index][1] < milliseconds - 200) // limit updates to 5 FPS
                    {
                        getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.CHANNELPRESSURE + 1, parseInt(vuMeter) + (trackNoToTrackNo(index) << 4), 0);
                        vuMeterLastSend[index][1] = milliseconds; // millisecs
                    }  
                }               
            }));

            track.volume().addValueObserver(16384, makeIndexedFunction(trackNo, function(index, value) // Fader positions
            {
                getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.PITCHBEND | trackNoToTrackNo(index), value & 127, value >> 7 & 127);
            }));

            track.getMute().addValueObserver(makeIndexedFunction(trackNo, function(index, on)
            {
                getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.MUTE0 + trackNoToTrackNo(index), on ? 127 : 0);
            }));

            track.getSolo().addValueObserver(makeIndexedFunction(trackNo, function(index, on)
            {
                getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.SOLO0 + trackNoToTrackNo(index), on ? 127 : 0);
            }));

            track.getArm().addValueObserver(makeIndexedFunction(trackNo, function(index, on)
            {
                getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.ARM0 + trackNoToTrackNo(index), on ? 127 : 0);
            }));

            track.getVolume().setLabel("V" + (trackNo + 1));
            track.getVolume().setIndication(true);

            track.addIsSelectedObserver(makeIndexedFunction(trackNo, function(index, isSelected)
            {
                if (isSelected)
                {
                    getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.SELECT0 + trackNoToTrackNo(index), 127);
                    this.selectedTrack = index;
                }
                else 
                    getMidiPortByTrack(index).sendMidi(MIDIMSGTYPES.NOTEON, CHANNEL_BUTTON.SELECT0 + trackNoToTrackNo(index), 0);
            }));

            track.getPan().addValueObserver(128, makeIndexedFunction(trackNo, function(index, value)
            {
                setEncoder(VPOT_PAGE.PAN, index, value);
                setEncoder(VPOT_PAGE.TRACK, index, value);
            }));
            track.getPan().addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value)
            {
                writeText(DISPLAY_PAGES.NAME_AND_PAN, index, 1, value);
            }));

            track.getSend(0).addValueObserver(128, makeIndexedFunction(trackNo, function(index, value)
            {
                setEncoder(VPOT_PAGE.SEND0, index, value);
            }));
            track.getSend(0).addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value)
            {
                writeText(DISPLAY_PAGES.NAME_AND_SEND0, index, 1, value);
            }));
            track.getSend(1).addValueObserver(128, makeIndexedFunction(trackNo, function(index, value)
            {
                setEncoder(VPOT_PAGE.SEND1, index, value);
            }));
            track.getSend(1).addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value)
            {
                writeText(DISPLAY_PAGES.NAME_AND_SEND1, index, 1, value);
            }));
            track.getSend(2).addValueObserver(128, makeIndexedFunction(trackNo, function(index, value)
            {
                setEncoder(VPOT_PAGE.SEND2, index, value);
            }));
            track.getSend(2).addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value)
            {
                writeText(DISPLAY_PAGES.NAME_AND_SEND2, index, 1, value);
            }));
            track.getSend(3).addValueObserver(128, makeIndexedFunction(trackNo, function(index, value)
            {
                setEncoder(VPOT_PAGE.SEND3, index, value);
            }));
            track.getSend(3).addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value)
            {
                writeText(DISPLAY_PAGES.NAME_AND_SEND3, index, 1, value);
            }));
            track.getSend(4).addValueObserver(128, makeIndexedFunction(trackNo, function(index, value)
            {
                setEncoder(VPOT_PAGE.SEND4, index, value);
            }));
            track.getSend(4).addValueDisplayObserver(SINGLE_DISPLAY_WIDTH, "", makeIndexedFunction(trackNo, function(index, value)
            {
                writeText(DISPLAY_PAGES.NAME_AND_SEND4, index, 1, value);
            }));

            track.color().addValueObserver(makeIndexedColorFunction(trackNo, function(index, r, g, b)
            {
                setColor(index, r, g, b);
            }));
        }
    }

    showPage(VPOT_PAGE.TRACK);


    //
    // # Master Track
    //

    masterTrack.getVolume().addValueObserver(16384, function(value)
    {
        sendPitchBend(8, value);
    });
    masterTrack.getVolume().setIndication(true);

    masterTrack.getMute().addValueObserver(function(on)
    {
        // RGB light red if master track muted
        getMidiPortByEx(0).sendMidi(MIDIMSGTYPES.NOTEON | 1, TRANSPORT.F3, on ? 127 : 0);
        getMidiPortByEx(0).sendMidi(MIDIMSGTYPES.NOTEON | 2, TRANSPORT.F3, 0);
        getMidiPortByEx(0).sendMidi(MIDIMSGTYPES.NOTEON | 3, TRANSPORT.F3, 0);
    });

    printText("Initialized");
}

function refreshEQPosition()
{
    var devCnt = deviceBank.itemCount().get();

    eqDevPosition = -1;

    for (var i = 0; i < devCnt; i++)
    {
        var nameDmy = devicesFromSelectedTrack[i].name().get();

        if (nameDmy.toLowerCase().startsWith("eq"))
        {
            eqDevPosition = i;
        }
    }

    if (eqDevPosition >= FXPagesCount) // outside of pages
        eqDevPosition = -1;
}

function checkPageStillValid()
{
    if (activePage == VPOT_PAGE.EQ) // EQ
    {
        if (eqDevPosition == -1)
        {
            showPage(VPOT_PAGE.TRACK);
            return;
        }
   
        var pageCnt = devicesFromSelectedTrackRemotePage[eqDevPosition][0].pageCount().get();

        if (pageCnt == 0 || eqDevPageOffset >= pageCnt)
        {
            showPage(VPOT_PAGE.TRACK);
            return;
        }
    }
    else if (activePage == VPOT_PAGE.FX) // Plugin
    {
        if (activePage != VPOT_PAGE.FX)
        {
            fxDevPageOffset = 0;
            if (deviceBank.itemCount().get())
                showPage(VPOT_PAGE.FX);
        }
        else
        {          
            if (fxDevPosition >= deviceBank.itemCount().get() || (deviceBank.itemCount().get() == 1 && eqDevPosition != -1))
            {
                showPage(VPOT_PAGE.TRACK);
                return;
            }

            var pageCnt = devicesFromSelectedTrackRemotePage[fxDevPosition][0].pageCount().get();

            if ((fxDevPageOffset) >= pageCnt)
            {
                showPage(VPOT_PAGE.TRACK);
                return;
            }
        }
    }
}

function exit()
{
    sendSysex(SYSEX_HDR + "61 f7"); // All faders to the bottom
    sendSysex(SYSEX_HDR + "63 f7"); // Everything off
}

function flush()
{

}

function onMidiMainDev(status, data1, data2)
{
    onMidi(0, status, data1, data2);
}

function onMidiExtension1(status, data1, data2)
{
    onMidi(1, status, data1, data2);
}

function onMidiExtension2(status, data1, data2)
{
    onMidi(2, status, data1, data2);
}

function onMidiExtension3(status, data1, data2)
{
    onMidi(3, status, data1, data2);
}

function onMidiExtension4(status, data1, data2)
{
    onMidi(4, status, data1, data2);
}

function onMidiExtension5(status, data1, data2)
{
    onMidi(5, status, data1, data2);
}

function onMidiExtension6(status, data1, data2)
{
    onMidi(6, status, data1, data2);
}

function onMidiExtension7(status, data1, data2)
{
    onMidi(7, status, data1, data2);
}

function GetMidiChannelFromStatus(status)
{
    return status & 0xF;
}

function onMidi(cable, status, data1, data2)
{
    //printMidi(status, data1, data2);

    if (isPitchBend(status)) ////////only the motor faders send/receive pitch bend messages(14bit --> 0 - 16383)
    {
        var index = GetMidiChannelFromStatus(status) + cable * 8;

        if (index == 8 && cable == 0) 
        {
            masterTrack.getVolume().set(pitchBendValue(data1, data2), 16384);
        }
        else if (GetMidiChannelFromStatus(status) < 8)
        {
            trackBank.getTrack(index).getVolume().set(pitchBendValue(data1, data2), 16384);
        }       
    }

    //all buttons, the click of the encoders and the touch of the motor faders send/receive note on messages (release a button = velocity 0)
    if (isNoteOn(status)) 
    {
        if (data1 == MODIFIER.SHIFT)
        {
            isShiftPressed = data2 > 0;
        }
        else if (data1 == MODIFIER.OPTION)
        {
            isResetPressed = data2 > 0;
        }
        else if (data1 == SCRUB) 
        {
            isScrubPressed = data2 > 0;
        }
        else if (data1 >= VPOT_CLICK0 && data1 < (VPOT_CLICK0 + 8)) //
        {
            getEncoderObjectPath(cable, data1 - VPOT_CLICK0).reset(); // if reset is pressed, reset the parameter of the clicked encoder to its default value
        }

        if (data2 > 0) // Check button presses (but not releases) in here
        {
            if (data1 >= VPOT_ASSIGN.TRACK && data1 <= VPOT_ASSIGN.INSTRUMENT) //  the 4 mode buttons change the vpot assignement and what's displayed 
            {
                switch (data1)
                {
                    case VPOT_ASSIGN.TRACK:
                        showPage(VPOT_PAGE.TRACK);                       
                        break;
                    case VPOT_ASSIGN.SEND:
                        if (activePage != VPOT_PAGE.SEND0 && activePage != VPOT_PAGE.SEND1 && activePage != VPOT_PAGE.SEND2 && activePage != VPOT_PAGE.SEND3 && activePage != VPOT_PAGE.SEND4)
                        {
                            showPage(VPOT_PAGE.SEND0);
                        }
                        else
                        {
                            if (activePage == VPOT_PAGE.SEND4 || activeDisplayPage == DISPLAY_PAGES.NAME_AND_SEND4)
                                showPage(VPOT_PAGE.TRACK);
                            else
                                showPage(activePage + 1);
                        }
                        break;
                    case VPOT_ASSIGN.PAN:
                        if (activePage != VPOT_PAGE.PAN)
                            showPage(VPOT_PAGE.PAN);
                        else
                            showPage(VPOT_PAGE.TRACK);
                        break;
                    case VPOT_ASSIGN.EQ: // EQ
                        if (eqDevPosition != -1 && activePage != VPOT_PAGE.EQ)
                        {
                            eqDevPageOffset = 0;
                            showPage(VPOT_PAGE.EQ);
                        }
                        else
                        {        
                            unshowPage(); 

                            if (eqDevPosition == -1)
                            {
                                showPage(VPOT_PAGE.TRACK); 
                                break;
                            }

                            var pageCnt = devicesFromSelectedTrackRemotePage[eqDevPosition][0].pageCount().get();
                            eqDevPageOffset += extensionCount;      

                            if (eqDevPageOffset >= pageCnt)
                            {
                                eqDevPageOffset = 0;
                                showPage(VPOT_PAGE.TRACK); 
                                break;
                            }

                            showPage(VPOT_PAGE.EQ);
                        }
                        break;
                    case VPOT_ASSIGN.FX: // Plugin
                        if (activePage != VPOT_PAGE.FX)
                        {
                            fxDevPageOffset = 0;
                            if (deviceBank.itemCount().get() > 1 || (deviceBank.itemCount().get() == 1 && eqDevPosition == -1))
                                showPage(VPOT_PAGE.FX);
                        }
                        else
                        {          
                            unshowPage(); 

                            var pageCnt = devicesFromSelectedTrackRemotePage[fxDevPosition][0].pageCount().get();

                            if ((fxDevPageOffset + extensionCount) >= pageCnt)
                            {
                                fxDevPosition++; // go to next device
                                fxDevPageOffset = 0; 
                            }
                            else
                                fxDevPageOffset += extensionCount; // stay in device and increase page

                            if (eqDevPosition != -1 && eqDevPosition <= fxDevPosition) // skip EQ in FXes
                                fxDevPosition++;

                            if (fxDevPosition >= deviceBank.itemCount().get())
                            {
                                fxDevPosition = 0;
                                showPage(VPOT_PAGE.TRACK); 
                                break;
                            }

                            showPage(VPOT_PAGE.FX);
                        }
                        break;
                }
            }

            // ///////////////////////////////////// channel buttons ///////

            else if (data1 >= 0 && data1 <= 7) // is one of the arm buttons pressed
            {
                var index = data1 - CHANNEL_BUTTON.ARM0 + cable * 8; //which arm button is pressed
                trackBank.getTrack(index).getArm().toggle(); // tell the application to toggle the state of the corresponding arm button
            }

            else if (data1 >= 8 && data1 <= 15) // is one of the solo buttons pressed
            {
                var index = data1 - CHANNEL_BUTTON.SOLO0 + cable * 8; //which solo button is pressed
                trackBank.getTrack(index).getSolo().toggle(); // tell the application to toggle the state of the corresponding solo button
            }
            else if (data1 >= 16 && data1 <= 23) // is one of the mute buttons pressed
            {

                var index = data1 - CHANNEL_BUTTON.MUTE0 + cable * 8; //which mute button is pressed
                trackBank.getTrack(index).getMute().toggle(); // tell the application to toggle the state of the corresponding mute button
            }
            else if (data1 >= 24 && data1 <= 31) // is a select button pressed
            {
                var index = data1 - CHANNEL_BUTTON.SELECT0 + cable * 8; //which select button is pressed
                trackBank.getTrack(index).select(); // tell the application to toggle the state of the corresponding arm button
            }
            else if (data1 >= 104 && data1 <= 111) // fader touch select
            {
                if (faderTouchSelectsChannel)
                {
                    var index = data1 - CHANNEL_BUTTON.TOUCH0 + cable * 8; //which select button is pressed
                    trackBank.getTrack(index).select(); // tell the application to toggle the state of the corresponding arm button
                }
            }

            // /////////////////////////////// transport ///////

            switch (data1)
            {
                case TRANSPORT.PLAY:
                    transport.play();
                    break;
                case TRANSPORT.STOP:
                    transport.stop();
                    break;
                case TRANSPORT.RECORD:
                    transport.record();
                    break;
                case TRANSPORT.REW:
                    transport.rewind();
                    break;
                case TRANSPORT.FF:
                    transport.fastForward();
                    break;
                case TRANSPORT.CYCLE:
                    transport.toggleLoop();
                    break;
                case TRANSPORT.CLICK:
                    transport.toggleClick();
                    break;
                case TRANSPORT.F1: // magic click
                    //application.getAction(magicActionID).invoke();
                    break;
                case TRANSPORT.F3: // vol click
                    masterTrack.mute().toggle();
                    break;
                case AUTOMATION.TRIM:
                    transport.toggleWriteClipLauncherAutomation();
                    break;
                case AUTOMATION.GROUP:
                    transport.resetAutomationOverrides();
                    break;
                case AUTOMATION.READ_OFF:
                    transport.toggleWriteArrangerAutomation();
                    break;
                case AUTOMATION.LATCH:
                    transport.setAutomationWriteMode("latch");
               if (!automationWrite) transport.toggleWriteArrangerAutomation();
                    break;
                case AUTOMATION.TOUCH:
                    transport.setAutomationWriteMode("touch");
               if (!automationWrite) transport.toggleWriteArrangerAutomation();
                    break;
                case AUTOMATION.WRITE:
                    transport.setAutomationWriteMode("write");
               if (!automationWrite) transport.toggleWriteArrangerAutomation();
                    break;
                case TRANSPORT.REPLACE:
                    transport.toggleOverdub();
                    break;
                case FADER_BANKS.FLIP:

                    break;
                case FADER_BANKS.BANK_UP:
                    trackBank.scrollChannelsPageUp();
                    // setIndications("pan");
                    break;
                case FADER_BANKS.BANK_DOWN:
                    trackBank.scrollChannelsPageDown();
                    // setIndications("pan");
                    break;
                case FADER_BANKS.CHANNEL_UP:
                    changeRemoteControlsPage(false);
                    break;
                case FADER_BANKS.CHANNEL_DOWN:
                    changeRemoteControlsPage(true);
                    break;
                case APPLICATION.CANCEL:
                    application.escape();
                    break;
                case APPLICATION.ENTER:
                    application.enter();
                    break;
                case APPLICATION.TOGGLE_NOTE_EDITOR:
                    application.toggleNoteEditor();
                    break;
                case APPLICATION.TOGGLE_DEVICES:
                    application.toggleDevices();
                    break;
                case APPLICATION.TOGGLE_AUTOMATION_EDITOR:
                    application.toggleAutomationEditor();
                    break;
                case APPLICATION.TOGGLE_MIXER:
                    application.toggleMixer();
                    break;
                case APPLICATION.TOGGLE_BROWSER:
                    application.toggleBrowserVisibility();
                    break;
                case TOGGLE_VU_METER:
                    break;

            }
        }
        else if (data2 == 0) // Check button release, no press
        {
            switch (data1)
            {
                case APPLICATION.UNDO_REDO:
                    sendNoteOn(0, APPLICATION.UNDO_REDO, 0);
                    break;
            }
        }
    }

    // ////////////////////////////////////// isChannelController //////

    if (isChannelController(status)) //encoders(vpots) and the wheel send/receive channel controller messages
    {
        var index = 0;
        var delta = data2;
        if (delta > 64) // if an encoder is turned counterclockwise..
        {
            delta = (-1) * (Math.round(delta) - 64); // ..do this math
        }

        /* vpots */
        if (data1 >= VPOT0 && data1 < (VPOT0 + 8)) // if the cc comes from a vpot..
        {
            if (activePage == VPOT_PAGE.EQ && eqDevPosition == -1)
                return;

            if (activePage == VPOT_PAGE.EQ && cable + eqDevPageOffset >= devicesFromSelectedTrackRemotePage[eqDevPosition][0].pageCount().get())
                return;

            if (activePage == VPOT_PAGE.FX && cable + fxDevPageOffset >= devicesFromSelectedTrackRemotePage[fxDevPosition][0].pageCount().get())
                return;
            
            getEncoderObjectPath(cable, data1 - VPOT0).inc(delta, 200); // ..get the target parameter dependent on the active encoder page and if flip is on or off
        }
    }
}

function onSysex(data)
{

}

function makeIndexedFunction(index, f) // this is needed to 
{
    return function(value)
    {
        f(index, value);
    };
}

function makeExtensionTrackFunction(exNo, trackNo, f) // this is needed to 
{
    return function(value)
    {
        f(exNo, trackNo, value);
    };
}

function makeDoubleIndexedFunction(i, j, f) // this is needed to 
{
    return function(value)
    {
        f(i, j, value);
    };
}

function makeTripleIndexedFunction(i, j, t, f) // this is needed to 
{
    return function(value)
    {
        f(i, j, t, value);
    };
}

function makeIndexedColorFunction(index, f) // this is needed to 
{
    return function(r, g, b)
    {
        f(index, r, g, b);
    };
}

function storeToParameterPageBuffer(page) // stores the page number of the parameter page so it can be recalled when switching to another mode and back
{
	this.parameterPageBuffer = page;
}

function getActiveParameterPage() // returns the page number of the active parameter page
{
	return parameterPageBuffer;
}

