load("Dxxx_var.js");


//
// # OLED Display
//

function DisplayStrip(extensionID)
{
    this.extensionID = extensionID;
    this.pages = [];
    this.visibleText = [];
    this.channelNos = [];

    this.activeFXDev = -1;
    this.activeFXPage = -1;

    for (var i = 0; i < 8; i++) // tracks
    {
        this.visibleText[i] = [];

        for (var ii = 0; ii < 3; ii++) // rows
        {
            this.visibleText[i][ii] = " ";
        }
    }

    for (var t = 0; t < VPOT_PAGES_COUNT; t++)
    {
        this.pages[t] = new DisplayPage();
    }
}

DisplayStrip.prototype.showPage = function(page)
{
    this.RefreshLineWithActivePage(0);
    this.RefreshLineWithActivePage(1);
    this.RefreshLineWithActivePage(2);
    this.wirteToLCDChannelNos();
}

DisplayStrip.prototype.setTrackNo = function(trackNo, no)
{
    if (this.channelNos[trackNo] == no)
        return;

    this.channelNos[trackNo] = no;
    this.wirteToLCDChannelNos();
}

DisplayStrip.prototype.wirteToLCDChannelNos = function()
{
    var sysExMessage = SYSEX_HDR; 
    sysExMessage += "17";
    sysExMessage += uint7ToHex(0);
    
    if (trackNosVisible)
        for (var i = 0; i < 8; i++)
            sysExMessage += ('0' + (this.channelNos[i] & 0xFF).toString(16)).slice(-2);
    else
        sysExMessage += "0000000000000000";

    sysExMessage += "f7";

    if (hasDisplay)
        getMidiPortByEx(this.extensionID).sendSysex(sysExMessage);
}

DisplayStrip.prototype.writeDisplayTextWithPage = function(page, trackNo, row, text)
{
	this.pages[page].setDisplayText(trackNo, row, text);

    if (activePage == page)
        this.RefreshText(trackNo, row, this.pages[page].text[trackNo][row]);
}

DisplayStrip.prototype.writeDisplayText = function(trackNo, row, text)
{
    this.RefreshText(trackNo, row, text);
}

DisplayStrip.prototype.RefreshLineWithActivePage = function(row)
{
    if (this.activeFXPage != -1 && this.activeFXDev != -1 && (row == 0 || row == 1 || row == 2)) // FX
    {
        for (var i = 0; i < 8; i++) // tracks
            this.RefreshText(i, row, FXDisplayPages[this.activeFXDev][this.activeFXPage].text[i][row]);

        return;
    }

    for (var i = 0; i < 8; i++) // tracks
        this.RefreshText(i, row, this.pages[activePage].text[i][row]);
}

DisplayStrip.prototype.RefreshText = function(trackNo, row, newText)
{
    var textWidth = row == 2 ? SINGLE_DISPLAY_WIDTH_THIRD : SINGLE_DISPLAY_WIDTH;

    if (this.visibleText[trackNo][row] == newText)
        return;

    this.visibleText[trackNo][row] = newText;

    this.writeToLCD(row, trackNo * textWidth, newText.forceLength(textWidth), textWidth);
}

DisplayStrip.prototype.writeToLCD = function(row, position, text, len)
{
    var sysExMessage = SYSEX_HDR; 

    text = text.forceLength(len);

    //printText(text);
    
    if (row == 2)
    {
        sysExMessage += "19";
        sysExMessage += uint7ToHex(position) + text.toHex(len) + "f7";
    }
    else
    {
        sysExMessage += "1a";
        sysExMessage += uint7ToHex(position) + uint7ToHex(row + 1) + text.toHex(len) + "f7";
    }
    
    

    if (hasDisplay)
        getMidiPortByEx(this.extensionID).sendSysex(sysExMessage);
}


function DisplayPage()
{
    this.text = [];

    for (var i = 0; i < 8; i++) // tracks
    {
        this.text[i] = [];

        for (var ii = 0; ii < 3; ii++) // rows
        {
            this.text[i][ii] = " ";
        }
    }
}

DisplayPage.prototype.setDisplayText = function(trackNo, row, text)
{
    this.text[trackNo][row] = text;
};


function setDisplayEncoderFunctionForPage(page, text)
{
    for (var exNo = 0; exNo < extensionCount; exNo++)
        for (var i = 0; i < 8; i++)
            Extensions[exNo].displayStrip.writeDisplayTextWithPage(page, i, 2, text);
}

function showDisplayTrackNo(trackNo, no)
{
    if (no < 1)
        return;    
    Extensions[trackNoToExtensionID(trackNo)].displayStrip.setTrackNo(trackNoToTrackNo(trackNo), no);       
}

function writeText(displayPage, trackNo, row, text)
{
    Extensions[trackNoToExtensionID(trackNo)].displayStrip.writeDisplayTextWithPage(displayPage, trackNoToTrackNo(trackNo), row, text);
}

function clearDisplayPage(page)
{
	for (var exNo = 0; exNo < extensionCount; exNo++)
		for (var i = 0; i < 8; i++)
        {
            Extensions[exNo].displayStrip.writeDisplayTextWithPage(page, i, 0, "");
            Extensions[exNo].displayStrip.writeDisplayTextWithPage(page, i, 1, "");
        }
}

function refreshFXDisplayPageLine(dev, page, row)
{
    for (var exNo = 0; exNo < extensionCount; exNo++)
    {
        if (Extensions[exNo].displayStrip.activeFXPage == page && Extensions[exNo].displayStrip.activeFXDev == dev)
            Extensions[exNo].displayStrip.RefreshLineWithActivePage(row);
    }
}
