load("Dxxx_var.js");


//
// # OLED Display
//


function DisplayPage(extensionID)
{
    this.textBuffer = [];
    this.extensionID = extensionID;

    for ( var i = 0; i < TOTAL_DISPLAY_SIZE; i++)
    {
        this.textBuffer[i] = ' ';
    }
}

DisplayPage.prototype.writeToColumnBuffer = function(row, column, text)
{
    var pos = row * DISPLAY_WIDTH + column * SINGLE_DISPLAY_WIDTH;

    var forcedText = text.forceLength(SINGLE_DISPLAY_WIDTH);

    for ( var i = 0; i < SINGLE_DISPLAY_WIDTH; i++)
    {
        this.textBuffer[pos + i] = forcedText[i];
    }
};

DisplayPage.prototype.writeToFullDisplaySizeBuffer = function(row, position, text, len)
{
    var pos = row * DISPLAY_WIDTH + position;
    var forcedText = text.forceLength(len);
    for ( var i = 0; i < len; i++)
    {
        this.textBuffer[pos + i] = forcedText[i];
    }
};

DisplayPage.prototype.sendToLCD = function()
{
    var text = "";

    for ( var i = 0; i < TOTAL_DISPLAY_SIZE; i++)
    {
        text += this.textBuffer[i];
    }

    //Send textBuffer contents to LCD display
    writeToLCD(0, 0, 0, text, TOTAL_DISPLAY_SIZE);
};

function setDisplayPage(displayPage)
{
    displayPages[0, displayPage].sendToLCD();
}

function writeToColumn(displayNo, displayPage, row, column, text)
{
    writeToLCD(displayNo, row, SINGLE_DISPLAY_WIDTH * column, text, SINGLE_DISPLAY_WIDTH);
    displayPages[displayNo, displayPage].writeToColumnBuffer(row, column, text);
}

function writeToDisplay(displayNo, displayPage, row, position, text, len)
{
    writeToLCD(displayNo, row, position, text, len);
    displayPages[displayNo, displayPage].writeToFullDisplaySizeBuffer(row, position, text, len);
}

var sendsInProgress = 0;

function writeToLCD(displayNo, row, position, text, len)
{
    var pos = row * DISPLAY_WIDTH + position;
    var sysExMessage = SYSEX_HDR + "18" + uint7ToHex(pos) + text.toHex(len) + "f7";

    sendsInProgress++;

    // Slow down messages to avoid overflow
    host.scheduleTask(function()
    {
        host.getMidiOutPort(displayNo).sendSysex(sysExMessage);
        sendsInProgress--;
    }, sendsInProgress * 3 + 1);

}

function clearLCD(displayNo)
{
    var sysExMessage = SYSEX_HDR + "18" + uint7ToHex(0) +  "                                                                                                                ".toHex(56 * 2) + "f7";
    host.getMidiOutPort(displayNo).sendSysex(sysExMessage);
}

function clearLCD2(displayNo)
{
    for ( var i = 0; i < 8; i++)
    {
        writeToLCD(displayNo, 0, SINGLE_DISPLAY_WIDTH * i, "       ", SINGLE_DISPLAY_WIDTH);
        writeToLCD(displayNo, 1, SINGLE_DISPLAY_WIDTH * i, "       ", SINGLE_DISPLAY_WIDTH);
    }
}


//
// # 8-digits displays
//

function setTransportPositionDisplay(position)
{
    return;

    for ( var i = 0; i < 10; i++)
    {
        var singleDigit = Number(position[i]);

        if (isNaN(singleDigit))
            singleDigit = 0;

        sendChannelController(0, 73 - i, 0x30 + singleDigit);
    }
}

